#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import importlib
import pkgutil

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError

class Command(BaseCommand):
    
    help = 'Scan all app Deploy.py and execute [name] function.'
    
    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="App name")

    def handle(self, *args, **options):
        name = options['name']

        for app in settings.INSTALLED_APPS:
            deploy = '%s.Deploy' % app
            
            if pkgutil.find_loader(deploy):
                deploy = importlib.import_module(deploy)
                func = getattr(deploy, name, None)
                if func:
                    print "execute %s.Deploy.%s" % (app, name)
                    result = func()
           

