#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11277 2018-11-29 07:20:01Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-11-29 16:20:01 +0900 (週四, 29 十一月 2018) $
# $Revision: 11277 $ 

import json
import logging
import hashlib
import urllib

from collections import OrderedDict

import requests

from lxml import etree
from django.shortcuts import render
from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator
from django.shortcuts import redirect, get_object_or_404
from django.core.urlresolvers import reverse
from django.contrib import messages
from django.views import generic
from django.utils.translation import ugettext as _
from django.conf import settings
from django.http import HttpResponse, Http404
from django.template.loader import get_template
from django.template import Context
from paypal.express.views import SuccessResponseView
from oscar.core.loading import get_model, get_class

from Iuppiter.Encoding import utf8
from Iuno.shop import forms
from Iuno.shop import buildAPIForm
from Iuno.shop.models import (
    ECPayTrade, AllPayTrade, SpgatewayTrade, CathaybkCreditTrade,
    ECPayLogisticTrade)
from Iuno.shop.Util import createCheckValue

_PaymentDetailsView = get_class('checkout.views', 'PaymentDetailsView')

Source = get_model('payment', 'Source')
SourceType = get_model('payment', 'SourceType')
Basket = get_model('basket', 'Basket')
Order = get_model('order', 'Order')

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

fileHandler = logging.FileHandler('Payment.log')
fileHandler.setLevel(logging.WARNING)
logger.addHandler(fileHandler)

SPGATEWAY = 'spgateway'
ALLPAY = 'allpay'
ECPAY = 'ecpay'
ECPAY_LOGISTIC = 'ecpay_logistic'
ECPAY_MAP = 'ecpay_map'

CATHAYBK_CREDIT = 'cathaybk-credit' # /cathaybk-credit/checkxml/
CATHAYBK_CUP = 'cathaybk-cup' # /cathaybk-cup/checkxml/
    
class SuccessResponseView(SuccessResponseView):
    def get_shipping_address(self, basket):
        return PaymentDetailsView.get_shipping_address(self, basket)

# patch
from oscar.apps.checkout import views
from oscar.apps.dashboard.orders.views import OrderListView
from oscar.core.compat import UnicodeCSVWriter
from django.utils.datastructures import SortedDict
from oscar.core.utils import format_datetime

def get_context_data(self, **kwargs):
    kwargs = super(views.PaymentDetailsView, self).get_context_data(**kwargs)
    
    submission = self.build_submission()

    ecpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ECPAY_ENABLE'):
        ecpayEnable = settings.IUNO_SHOP_ECPAY_ENABLE

    allpayEnable = False
    if hasattr(settings, 'IUNO_SHOP_ALLPAY_ENABLE'):
        allpayEnable = settings.IUNO_SHOP_ALLPAY_ENABLE

    spgatewayEnable = False
    if hasattr(settings, 'IUNO_SHOP_SPGATEWAY_ENABLE'):
        spgatewayEnable = settings.IUNO_SHOP_SPGATEWAY_ENABLE

    cathaybkEnable = False
    if hasattr(settings, 'IUNO_SHOP_CATHAYBK_ENABLE'):
        cathaybkEnable = settings.IUNO_SHOP_CATHAYBK_ENABLE
    
    if ecpayEnable:
        kwargs['ecpay'] = buildAPIForm(submission, self.request, 'ecpay')
        kwargs['ecpay_map'] = \
            buildAPIForm(submission, self.request, 'ecpay_map')
    if allpayEnable:
        kwargs['allpay'] = buildAPIForm(submission, self.request, 'allpay')
    if spgatewayEnable:
        kwargs['spgateway'] = buildAPIForm(
                                        submission, self.request, 'spgateway')
    if cathaybkEnable:
        kwargs['cathaybk'] = buildAPIForm(
                                        submission, self.request, 'cathaybk')
    
    return kwargs

views.PaymentDetailsView.get_context_data = get_context_data

def download_selected_orders(self, request, orders):
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename=%s' \
        % self.get_download_filename(request)
    writer = UnicodeCSVWriter(open_file=response)

    meta_data = (('number', _('Order number')),
                    ('value', _('Order value')),
                    ('date', _('Date of purchase')),
                    ('num_items', _('Number of items')),
                    ('status', _('Order status')),
                    ('customer', _('Customer email address')),
                    ('shipping_address_name', _('Deliver to name')),
                    ('billing_address_name', _('Bill to name')),
                    ('address', _('Address')),
                    ('phone', _('Phone')),
                    ('product', _('Product')),
                    )
    columns = SortedDict()
    for k, v in meta_data:
        columns[k] = v

    writer.writerow(columns.values())
    for order in orders:
        row = columns.copy()
        row['number'] = order.number
        row['value'] = order.total_incl_tax
        row['date'] = format_datetime(order.date_placed, 'DATETIME_FORMAT')
        row['num_items'] = order.num_items
        row['status'] = order.status
        row['customer'] = order.email
        row['address'] = ''
        
        phone = '%s' % order.shipping_address.phone_number
        
        # #FIXME:
        # 目前電話去掉+886換0是給台灣用的
        row['phone'] = phone.replace('+886', '0')
        
        row['product'] = ''
        
        for field in order.shipping_address.active_address_fields():
            row['address'] += "%s \n" % field
        
        for i, line in enumerate(order.basket.lines.all(), 1):
            product = line.product
            attributes = product.attribute_summary
            description = line.description
            row['product'] += \
                "%d : %s(%s) X %d \n" % (i, description, 
                                            attributes, line.quantity)
        
        if order.shipping_address:
            row['shipping_address_name'] = order.shipping_address.name
        else:
            row['shipping_address_name'] = ''
        if order.billing_address:
            row['billing_address_name'] = order.billing_address.name
        else:
            row['billing_address_name'] = ''
        writer.writerow(row.values())
        
    response.content = '\xEF\xBB\xBF' + response.content
    
    return response

OrderListView.download_selected_orders = download_selected_orders

from datetime import timedelta
from decimal import Decimal as D
from decimal import ROUND_UP

from oscar.apps.dashboard.views import IndexView
from oscar.core.compat import get_user_model
from django.db.models import Avg, Count, Sum
from django.utils.timezone import now

StockAlert = get_model('partner', 'StockAlert')
Line = get_model('order', 'Line')
User = get_user_model()

def get_hourly_report(self, hours=24, segments=10):
    """
    Get report of order revenue split up in hourly chunks. A report is
    generated for the last *hours* (default=24) from the current time.
    The report provides ``max_revenue`` of the hourly order revenue sum,
    ``y-range`` as the labeling for the y-axis in a template and
    ``order_total_hourly``, a list of properties for hourly chunks.
    *segments* defines the number of labeling segments used for the y-axis
    when generating the y-axis labels (default=10).
    """
    # Get datetime for 24 hours agao
    time_now = now().replace(minute=0, second=0)
    start_time = time_now - timedelta(hours=hours - 1)

    # query all OrderNote
    orders = Order.objects.exclude(status=u'測試用訂單')
    orders_last_day = orders.filter(date_placed__gt=start_time)

    order_total_hourly = []
    for hour in range(0, hours, 2):
        end_time = start_time + timedelta(hours=2)
        hourly_orders = orders_last_day.filter(date_placed__gt=start_time,
                                                date_placed__lt=end_time)
        total = hourly_orders.aggregate(
            Sum('total_incl_tax')
        )['total_incl_tax__sum'] or D('0.0')
        order_total_hourly.append({
            'end_time': end_time,
            'total_incl_tax': total
        })
        start_time = end_time

    max_value = max([x['total_incl_tax'] for x in order_total_hourly])
    divisor = 1
    while divisor < max_value / 50:
        divisor *= 10
    max_value = (max_value / divisor).quantize(D('1'), rounding=ROUND_UP)
    max_value *= divisor
    if max_value:
        segment_size = (max_value) / D('100.0')
        for item in order_total_hourly:
            item['percentage'] = int(item['total_incl_tax'] / segment_size)

        y_range = []
        y_axis_steps = max_value / D(str(segments))
        for idx in reversed(range(segments + 1)):
            y_range.append(idx * y_axis_steps)
    else:
        y_range = []
        for item in order_total_hourly:
            item['percentage'] = 0

    ctx = {
        'order_total_hourly': order_total_hourly,
        'max_revenue': max_value,
        'y_range': y_range,
    }
    return ctx

def get_stats(self):
    datetime_24hrs_ago = now() - timedelta(hours=24)

    # query all OrderNote
    orders = Order.objects.exclude(status=u'測試用訂單')
    orders_last_day = orders.filter(date_placed__gt=datetime_24hrs_ago)

    open_alerts = StockAlert.objects.filter(status=StockAlert.OPEN)
    closed_alerts = StockAlert.objects.filter(status=StockAlert.CLOSED)

    total_lines_last_day = Line.objects.filter(
        order__in=orders_last_day).count()
    stats = {
        'total_orders_last_day': orders_last_day.count(),
        'total_lines_last_day': total_lines_last_day,

        'average_order_costs': orders_last_day.aggregate(
            Avg('total_incl_tax')
        )['total_incl_tax__avg'] or D('0.00'),

        'total_revenue_last_day': orders_last_day.aggregate(
            Sum('total_incl_tax')
        )['total_incl_tax__sum'] or D('0.00'),

        'hourly_report_dict': self.get_hourly_report(hours=24),
        'total_customers_last_day': User.objects.filter(
            date_joined__gt=datetime_24hrs_ago,
        ).count(),

        'total_open_baskets_last_day': self.get_open_baskets({
            'date_created__gt': datetime_24hrs_ago
        }).count(),

        'total_products': Product.objects.count(),
        'total_open_stock_alerts': open_alerts.count(),
        'total_closed_stock_alerts': closed_alerts.count(),

        'total_site_offers': self.get_active_site_offers().count(),
        'total_vouchers': self.get_active_vouchers().count(),
        'total_promotions': self.get_number_of_promotions(),

        'total_customers': User.objects.count(),
        'total_open_baskets': self.get_open_baskets().count(),
        'total_orders': orders.count(),
        'total_lines': Line.objects.count(),
        'total_revenue': orders.aggregate(
            Sum('total_incl_tax')
        )['total_incl_tax__sum'] or D('0.00'),

        'order_status_breakdown': orders.order_by(
            'status'
        ).values('status').annotate(freq=Count('id'))
    }
    return stats

IndexView.get_stats = get_stats
IndexView.get_hourly_report = get_hourly_report

from django.core.mail import send_mail
from des.models import DynamicEmailConfiguration
from django.contrib.sites.models import Site
from oscar.apps.order.processing import EventHandler

def handle_order_status_change(self, order, new_status, note_msg=None):
    """
    Handle a requested order status change

    This method is not normally called directly by client code.  The main
    use-case is when an order is cancelled, which in some ways could be
    viewed as a shipping event affecting all lines.
    """
    order.set_status(new_status)
    
    if new_status == u'商品送貨中':
        try:
            temp = get_template(
                'shop/customer/emails/BeingProcessedSubject.txt')
            ctx = Context({
                "order": order,
                "site": Site.objects.get(id=settings.SITE_ID)
            })
            subject = temp.render(ctx)
            
            temp = get_template('shop/customer/emails/BeingProcessedBody.html')
            htmlContent = temp.render(ctx)
                        
            temp = get_template('shop/customer/emails/BeingProcessedBody.txt')
            txtContent = temp.render(ctx)
            
            if order.user:
                email = order.user.email
            else:
                email = order.guest_email
                                
            success = send_mail(
                subject,
                txtContent,
                DynamicEmailConfiguration.objects.get().from_email,
                [email,],
                html_message=htmlContent,
                fail_silently=False,
            )
                                
            if success:
                logger.info("Send order email success: %s" % email)
            else:
                logger.error("Send order email fail: %s" % email)
        except Exception as e:
            logger.error("Error Send order email: %s" % e)
    
    if note_msg:
        self.create_note(order, note_msg)

EventHandler.handle_order_status_change = handle_order_status_change

# ------------------------------------------------------------------------------
# /cathaybk/preview/
# /cathaybk-credit/checkxml/
@csrf_exempt
def returnCathaybkCreditXml(request):
    if request.POST:
        try:
            # get data
            xml = request.POST.get("strRsXML", None)
            if not xml:
                raise ValueError("Not strRsXM in post data.")

            root = etree.fromstring(utf8(xml))

            data = {}

            for child in root:
                if child.tag == "CAVALUE":
                    data["CAVALUE"] = child.text
                if child.tag in ["ORDERINFO", "AUTHINFO"]:
                    for child2 in child:
                        data[child2.tag] = child2.text

            #record data
            def parseDate(date):
                year = date[0:4]
                month = date[4:6]
                day = date[6:8]
                return "%s-%s-%s" % (year, month, day)

            if not data.get("AUTHCODE", ""):
                tradeNo = "NO_TRADE_NO"
            else:
                tradeNo = data.get("AUTHCODE", "NO_TRADE_NO")

            cathaybkCreditTrade = CathaybkCreditTrade.objects.create(
                tradeNo=tradeNo,
                tradeAmt=int(data.get("AMOUNT", "0")),
                merchantId=data.get("STOREID", ""),
                merchantTradeNo=data.get("ORDERNUMBER", ""),
                rtnCode=data.get("AUTHSTATUS", ""),
                paymentDate=parseDate(data.get("AUTHTIME", "11111111")),
                rtnMsg=data.get("AUTHMSG", ""),
                cardNo=data.get("CARDNO", ""),
            )
            cathaybkCreditTrade.save()

            # check
            status = data.get('AUTHSTATUS', None)
            if not status == '0000':
                raise ValueError("AUTHSTATUS: %s" % status)
        except Exception as e:
            logger.error('%s API ERROR: %s\n%s' % (
                    CATHAYBK_CREDIT, request.POST, str(e)))
        finally:
            # return xml
            scheme = request.scheme
            domain = request.META['HTTP_HOST']

            url = "%s://%s/%s/preview/" % (scheme, domain, CATHAYBK_CREDIT)

            checkValue = hashlib.md5(
                domain + settings.CATHAYBK_API_CUBKEY).hexdigest()
            
            temp = get_template('shop/payment/CathaybkReturn.xml')
            context = Context({
                'checkValue': checkValue,
                'returnUrl': url,
            })
            rtXml = temp.render(context)

            return HttpResponse(rtXml)
    else:
        logger.error("returnCathaybkCreditXml run to GET")
        scheme = request.scheme
        domain = request.META['HTTP_HOST']

        url = "%s://%s/%s/preview/" % (scheme, domain, CATHAYBK_CREDIT)

        checkValue = hashlib.md5(
            domain + settings.CATHAYBK_API_CUBKEY).hexdigest()
        
        temp = get_template('shop/payment/CathaybkReturn.xml')
        context = Context({
            'checkValue': checkValue,
            'returnUrl': url,
        })
        rtXml = temp.render(context)

        return HttpResponse(rtXml)

class SuccessResponseView2(_PaymentDetailsView):
    preview = True
    http_method_names = ['post',]
    
    @method_decorator(csrf_exempt)
    def dispatch(self, request, *args, **kwargs):
        return super(SuccessResponseView2, self).dispatch(request, 
                                                         *args, **kwargs)
    
    def post(self, request, *args, **kwargs):
        # apiName
        self.apiName = kwargs['name']
        
        if not self.apiName in [
            SPGATEWAY, ALLPAY, ECPAY, CATHAYBK_CREDIT, 
            CATHAYBK_CUP, ECPAY_MAP, ECPAY_LOGISTIC]:
            raise ValueError("Not pay api name: %s" % apiName)

        try:
            if self.apiName in [ALLPAY, ECPAY]:
                # data
                self.tradeNo = request.POST.get('TradeNo')
                self.tradeAmt = request.POST.get('TradeAmt')
                self.merchantID = request.POST.get('MerchantID')
                self.merchantTradeNo = request.POST.get('MerchantTradeNo')
                self.rtnCode = request.POST.get('RtnCode')
                self.rtnMsg = request.POST.get('RtnMsg')
                self.payAmt = request.POST.get('MerchantID')
                self.tradeDate = request.POST.get('TradeDate')
                self.paymentType = request.POST.get('PaymentType')
                self.simulatePaid = request.POST.get('SimulatePaid')
                self.paymentDate = request.POST.get('PaymentDate')
                self.paymentTypeChargeFee = request.POST.get(
                                                        'PaymentTypeChargeFee')

                # basket
                index = request.POST.get('MerchantTradeNo').find('BASKETID')
                self.basketId = int(
                                request.POST.get('MerchantTradeNo')[index + 8:])

                # error
                if self.rtnMsg == 'ERROR':
                    msg = _(
                        "There was an error in the payment. Please try again.")
                    messages.error(self.request, msg)
                    logger.error(
                        '%s API ERROR: %s' % (self.apiName, request.POST))
                    return redirect('checkout:payment-details')
            
                # record trade data
                if self.apiName == ECPAY:
                    ecpayTrade = ECPayTrade.objects.create(
                        tradeNo=self.tradeNo,
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        payAmt=int(self.payAmt),
                        tradeDate=self.tradeDate.replace('/', '-'),
                        paymentType=self.paymentType,
                        simulatePaid=self.simulatePaid,
                        paymentDate=self.paymentDate.replace('/', '-'),
                        paymentTypeChargeFee=self.paymentTypeChargeFee,
                        rtnMsg=self.rtnMsg,
                    )
                    ecpayTrade.save()
                else:
                    allpayTrade = AllPayTrade.objects.create(
                        tradeNo=self.tradeNo,
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        payAmt=int(self.payAmt),
                        tradeDate=self.tradeDate.replace('/', '-'),
                        paymentType=self.paymentType,
                        simulatePaid=self.simulatePaid,
                        paymentDate=self.paymentDate.replace('/', '-'),
                        paymentTypeChargeFee=self.paymentTypeChargeFee,
                        rtnMsg=self.rtnMsg,
                    )
                    allpayTrade.save()
            elif self.apiName == SPGATEWAY:
                # data
                data = json.loads(request.POST.get('JSONData', '{}'))
                
                self.status = data.get('Status')
                self.message = data.get('Message')
                self.result = json.loads(data.get('Result', '{}'))
                self.tradeNo = self.result.get("TradeNo")
                self.tradeAmt = self.result.get("Amt")
                self.merchantID = self.result.get("MerchantID")
                self.merchantTradeNo = self.result.get("MerchantOrderNo")
                self.rtnCode = self.result.get("RespondCode")
                self.tradeDate = self.result.get("PayTime")
                self.paymentMethod = self.result.get("PaymentMethod")
                self.paymentType = self.result.get("PaymentType")
                
                # basket
                index = self.result.get('MerchantOrderNo').find('BASKETID')
                self.basketId = int(
                    self.result.get('MerchantOrderNo')[index + 8:])

                # error
                if not self.status == 'SUCCESS':
                    msg = _(
                        "There was an error in the payment. Please try again.")
                    messages.error(self.request, msg)
                    logger.error(
                        '%s API ERROR: %s' % (self.apiName, request.POST))
                    return redirect('checkout:payment-details')

                # record trade data
                spgatewayTrade = SpgatewayTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    paymentDate=self.tradeDate.replace('/', '-'),
                    paymentType=self.paymentType,
                    paymentMethod=self.paymentMethod,
                    rtnMsg=self.message,
                )
                spgatewayTrade.save()
            elif self.apiName == CATHAYBK_CREDIT:
                self.status = 'XXXX'
                msg = _("There was an error in the payment. Please try again.")

                # get data
                xml = request.POST.get("strRsXML", None)
                if not xml:
                    logger.error(
                        "Not strRsXML in post data.: %s" % request.POST)
                    messages.error(self.request, msg)
                    return redirect('checkout:payment-details')

                root = etree.fromstring(utf8(xml))
                data = {}
                for child in root:
                    if child.tag == "CAVALUE":
                        data["CAVALUE"] = child.text
                    if child.tag in ["ORDERINFO",]:
                        for child2 in child:
                            data[child2.tag] = child2.text

                # get obj & check
                self.merchantTradeNo = data.get("ORDERNUMBER", "")
                if not CathaybkCreditTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                    messages.error(self.request, msg)
                    return redirect('checkout:payment-details')
                cathaybkCreditTrade = CathaybkCreditTrade.objects.get(
                    merchantTradeNo=self.merchantTradeNo)
                self.status = cathaybkCreditTrade.rtnCode
                if not cathaybkCreditTrade.rtnCode == '0000':
                    messages.error(
                        self.request, 
                        msg + ": %s %s" % (cathaybkCreditTrade.rtnCode, 
                                           cathaybkCreditTrade.rtnMsg))
                    return redirect('checkout:payment-details') 

                # data
                index = cathaybkCreditTrade.merchantTradeNo.find('BASKETID')
                self.basketId = int(
                    cathaybkCreditTrade.merchantTradeNo[index + 8:])

                self.tradeNo = cathaybkCreditTrade.tradeNo
                self.tradeAmt = cathaybkCreditTrade.tradeAmt
            elif self.apiName == ECPAY_MAP:
                submission = super(
                    SuccessResponseView2, self).build_submission(**kwargs)
                form = buildAPIForm(submission, self.request, ECPAY_LOGISTIC)

                if hasattr(settings, "ECPAY_API_LOGISTIC_SUB_TYPES"):
                    subTypes = settings.ECPAY_API_LOGISTIC_SUB_TYPES
                else:
                    subTypes = {
                        "FAMI": u"全家便利商店",
                        "UNIMART": u"統一7-11超商" ,
                        "HILIFE": u"萊爾富",
                    }

                data = {
                    'storeName': self.request.POST.get('CVSStoreName'),
                    'storeAddress': self.request.POST.get('CVSAddress'),
                    'storeType': subTypes[
                        self.request.POST.get('LogisticsSubType')],
                    'storePhone': self.request.POST.get('CVSTelephone'),
                    'form': form,
                }
                
                return render(request, 'shop/payment/EcpayMapCheck.html', data)

            elif self.apiName == ECPAY_LOGISTIC:
                # data 
                self.tradeNo = request.POST.get('AllPayLogisticsID')
                self.tradeAmt = request.POST.get('GoodsAmount')

                self.merchantTradeNo = request.POST.get('MerchantTradeNo')
                index = self.merchantTradeNo.find('BASKETID')
                self.basketId = int(self.merchantTradeNo[index + 8:])

                self.merchantID = request.POST.get('MerchantID')
                self.rtnCode = request.POST.get('RtnCode')
                self.rtnMsg = request.POST.get('RtnMsg')
                
                self.updateStatusDate = request.POST.get('UpdateStatusDate')
                self.receiverName = request.POST.get('ReceiverName')
                self.receiverCellPhone = request.POST.get('ReceiverCellPhone')
                self.receiverEmail = request.POST.get('ReceiverEmail')
                self.logisticsType = request.POST.get('LogisticsType')
                self.logisticsSubType = request.POST.get('LogisticsSubType')

                self.paymentNo = request.POST.get('CVSPaymentNo')
                self.validationNo = request.POST.get('CVSValidationNo')
                
                # error
                if self.rtnMsg == 'ERROR':
                    msg = _(
                        "There was an error in the payment. Please try again.")
                    messages.error(self.request, msg)
                    logger.error(
                        '%s API ERROR: %s' % (self.apiName, request.POST))
                    return redirect('checkout:payment-details')

                # record
                """
                for f in self.request.POST:
                    print "%s: %s" % (f, self.request.POST[f])
                """
                logisticTrade = ECPayLogisticTrade.objects.create(
                    tradeNo=self.tradeNo,
                    tradeAmt=int(self.tradeAmt),
                    merchantId=self.merchantID,
                    merchantTradeNo=self.merchantTradeNo,
                    rtnCode=self.rtnCode,
                    rtnMsg=self.rtnMsg,
                    tradeDate=self.updateStatusDate.replace('/', '-'),
                    updateStatusDate=self.updateStatusDate.replace('/', '-'),
                    receiverName=self.receiverName,
                    receiverCellPhone=self.receiverCellPhone,
                    receiverEmail=self.receiverEmail,
                    logisticsType=self.logisticsType,
                    logisticsSubType=self.logisticsSubType,
                    paymentNo=self.paymentNo,
                    validationNo=self.validationNo,
                )
                

            return self.handle_place_order_submission(request)
        except Exception as e:
            # return msg
            logger.error(str(e))
            
            # if payment success
            msg1 = _("There was an except error in the payment."
                     " We have notified the administrator to deal with refund.")

            # if payment not success
            msg2 = _("There was an error in the payment. Please try again.")

            # call admin
            if self.apiName == ALLPAY:
                if not self.rtnMsg == 'ERROR':
                    if not AllPayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            elif self.apiName == ECPAY:
                if not self.rtnMsg == 'ERROR':
                    if not ECPayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            elif self.apiName == SPGATEWAY:
                if self.status == 'SUCCESS':
                    if not SpgatewayTrade.objects.filter(
                        merchantTradeNo=self.merchantTradeNo).exists():
                        logger.error(
                            '%s API ERROR(this need to refund):\n%s\n%s' % (
                                self.apiName, request.POST, str(e)))
                        messages.error(self.request, msg1)
                    else:
                        logger.error(str(e))
                        order = Order.objects.get(basket=request.basket)
                        url = "%s?order_id=%d" % (
                            reverse('checkout:thank-you'), order.id)
                        return redirect(url)
                else:
                    logger.error(
                        '%s API ERROR:\n%s\n%s' % (
                            self.apiName, request.POST, str(e)))
                    messages.error(self.request, msg2)
            

            return redirect('checkout:payment-details')
        
        
    def build_submission(self, **kwargs):
        submission = super(
            SuccessResponseView2, self).build_submission(**kwargs)
        
        
        submission['payment_kwargs']['tradeNo'] = self.tradeNo
        submission['payment_kwargs']['tradeAmt'] = self.tradeAmt
        submission['payment_kwargs']['basketId'] = self.basketId
        return submission

    
    def handle_payment(self, order_number, total, **kwargs):
        tradeAmt = int(kwargs['tradeAmt'])
        tradeNo = kwargs['tradeNo']
        source_type, is_created = SourceType.objects.get_or_create(
            name=self.apiName)
        source = Source(source_type=source_type,
                        currency='TWD',
                        amount_allocated=tradeAmt,
                        amount_debited=tradeAmt,
                        reference=tradeNo) 
        
        self.add_payment_source(source)
        self.add_payment_event('Settled', tradeAmt,
                               reference=tradeNo)

class ECPayLogisticreturnView(generic.View):

    http_method_names = ['get', 'post',]

    def get(self, request, *args, **kwargs):
        orderNumber = kwargs.get('orderNumber')
        order = get_object_or_404(Order, number=orderNumber)
        source = get_object_or_404(
            Source, order=order, source_type__name='ecpay_logistic')
        trade = get_object_or_404(ECPayLogisticTrade, tradeNo=source.reference)
        
        return render(
            request, 
            "shop/payment/EcpayReturn.html",
            {
                'order': order,
                'trade': trade,
            }
        )

    def post(self, request, *args, **kwargs):
        orderNumber = kwargs.get('orderNumber')
        order = get_object_or_404(Order, number=orderNumber)
        source = get_object_or_404(
            Source, order=order, source_type__name='ecpay_logistic')
        trade = get_object_or_404(ECPayLogisticTrade, tradeNo=source.reference)
        """
        if trade.rtnMerchantTradeNo:
            messages.error(self.request, u"已送出退貨訊息")
            return redirect('customer:order-list')
        """
        data = {
            'MerchantID': trade.merchantId,
            'ServerReplyURL': reverse("ecpayLogisticReply"),
            'GoodsAmount': trade.tradeAmt,
            #'GoodsName': "Reference ",
            'ServiceType': 4, # 退貨不付款
            'SenderName': trade.receiverName,
            'SenderPhone': trade.receiverCellPhone,
            'AllPayLogisticsID': trade.tradeNo,
        }

        apiUrls = {
            "FAMI": {
                "stage": "https://logistics-stage.ecpay.com.tw/express/ReturnCVS",
                "production": "https://logistics-stage.ecpay.com.tw/express/ReturnCVS", 
            },
            "UNIMART": {
                "stage": "https://logistics-stage.ecpay.com.tw/express/ReturnUniMartCVS",
                "production": "https://logistics.ecpay.com.tw/express/ReturnUniMartCVS", 
            },
            "HILIFE": {
                "stage": "https://logistics-stage.ecpay.com.tw/express/ReturnHiLifeCVS",
                "production": "https://logistics.ecpay.com.tw/express/ReturnHiLifeCVS", 
            },
        }

        if settings.ECPAY_SANDBOX_MODE:
            apiUrl = apiUrls[trade.logisticsSubType]["stage"]
        else:
            apiUrl = apiUrls[trade.logisticsSubType]["production"]

        data["CheckMacValue"] = createCheckValue(data)

        res = requests.post(apiUrl, data=data)

        if not "ErrorMessage" in res.text:
            messages.success(self.request, u"成功送出退貨訊息")
            rtnMerchantTradeNo = res.text.split("|")[0]
            rtnOrderNo = res.text.split("|")[1]

            trade.rtnMerchantTradeNo = rtnMerchantTradeNo 
            trade.rtnOrderNo = rtnOrderNo
            trade.rtnMsg = u"已送出退貨資料"
            trade.rtnCode = 100 # 固定
            trade.save()
            
            order.status = "Order return"
            order.save()

            return redirect('customer:order-list')
        else:
            messages.error(self.request, u"送出退貨訊息失敗")
            return redirect('customer:order-list')


class ECPayServerReplyView(generic.View):

    http_method_names = ['get', 'post',]

    @csrf_exempt
    def dispatch(self, request, *args, **kwargs):
        return super(ECPayServerReplyView, self).dispatch(
            request, *args, **kwargs)

    def get(self, request, *args, **kwargs):
        return render("|ErrorMessage")

    def post(self, request, *args, **kwargs):
        # data 
        try:
            self.tradeNo = request.POST.get('AllPayLogisticsID')
            self.tradeAmt = request.POST.get('GoodsAmount')

            self.merchantTradeNo = request.POST.get('MerchantTradeNo')

            self.merchantID = request.POST.get('MerchantID')
            self.rtnCode = request.POST.get('RtnCode')
            self.rtnMsg = request.POST.get('RtnMsg')
            
            self.updateStatusDate = request.POST.get('UpdateStatusDate')
            self.receiverName = request.POST.get('ReceiverName')
            self.receiverCellPhone = request.POST.get('ReceiverCellPhone')
            self.receiverEmail = request.POST.get('ReceiverEmail')
            self.logisticsType = request.POST.get('LogisticsType')
            self.logisticsSubType = request.POST.get('LogisticsSubType')

            self.rtnMerchantTradeNo = request.POST.get('RtnMerchantTradeNo')

            if self.rtnMerchantTradeNo:
                logisticTrade = ECPayLogisticTrade.objects.filter(
                    tradeNo=self.tradeNo).update(
                        rtnCode=self.rtnCode,
                        rtnMsg=self.rtnMsg,
                        updateStatusDate=self.updateStatusDate.replace(
                            '/', '-'),
                )
                return HttpResponse("1|OK")
            else:
                index = self.merchantTradeNo.find('BASKETID')
                self.basketId = int(self.merchantTradeNo[index + 8:])

                order = Order.objects.get(basket=self.basketId)

                if self.rtnCode in ['2030', '3024', '2063', '3018']:
                    order.status = 'Order being processed'
                elif self.rtnCode in ['2067', '3022']:
                    order.status = 'Order complete'
                elif self.rtnCode in ['2074', '3020']:
                    order.status = 'Order return'
                else:
                    return HttpResponse("|ErrorMessage")
                order.save()

                logisticTrade = ECPayLogisticTrade.objects.filter(
                    tradeNo=self.tradeNo).update(
                        tradeAmt=int(self.tradeAmt),
                        merchantId=self.merchantID,
                        merchantTradeNo=self.merchantTradeNo,
                        rtnCode=self.rtnCode,
                        rtnMsg=self.rtnMsg,
                        updateStatusDate=self.updateStatusDate.replace('/', '-'),
                        receiverName=self.receiverName,
                        receiverCellPhone=self.receiverCellPhone,
                        receiverEmail=self.receiverEmail,
                        logisticsType=self.logisticsType,
                        logisticsSubType=self.logisticsSubType,
                )

                return HttpResponse("1|OK")
        except Exception as e:
            logger.error(str(e))
            return HttpResponse("|ErrorMessage")





class ECPayTransactionListView(generic.ListView):
    model = ECPayTrade
    template_name = 'shop/payment/dashboard/ECPay.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            ECPayTransactionListView, self).get_queryset().order_by('-id')

class AllPayTransactionListView(generic.ListView):
    model = AllPayTrade
    template_name = 'shop/payment/dashboard/AllPay.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            AllPayTransactionListView, self).get_queryset().order_by('-id')

class SpgatewayTransactionListView(generic.ListView):
    model = SpgatewayTrade
    template_name = 'shop/payment/dashboard/Spgateway.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            SpgatewayTransactionListView, self).get_queryset().order_by('-id')

class CathaybkCreditTransactionListView(generic.ListView):
    model = CathaybkCreditTrade
    template_name = 'shop/payment/dashboard/CathayCredit.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            CathaybkCreditTransactionListView, self
            ).get_queryset().order_by('-id')

class ECPayLogisticTransactionListView(generic.ListView):
    model = ECPayLogisticTrade
    template_name = 'shop/payment/dashboard/ECPayLogistic.html'
    context_object_name = 'transactions'

    def get_queryset(self):
        return super(
            ECPayLogisticTransactionListView, self
            ).get_queryset().order_by('-id')
    
# https://code.nuwainfo.com/trac/phantasos/ticket/589#ticket
from oscar.apps.dashboard.catalogue import tables
from oscar.apps.dashboard.catalogue import views as catalogueViews
from oscar.core.loading import get_model
from django_tables2 import A, TemplateColumn
from django.utils.translation import ugettext_lazy as _

Product = get_model('catalogue', 'Product')

class ProductTable(tables.ProductTable):
    categories = TemplateColumn(
        verbose_name=_('Categories'),
        accessor=A('categories'),
        template_name='shop/dashboard/catalogue/ProductRowCategory.html',
        orderable=False,
    )

    class Meta(tables.ProductTable.Meta):
        model = Product
        fields = ('upc', 'date_updated')
        sequence = ('title', 'upc', 'image', 'product_class', 
                    'categories', 'variants',
                    'stock_records', '...', 'date_updated', 'actions')
        order_by = '-date_updated'
        
catalogueViews.ProductListView.table_class = ProductTable

    

        
    


