#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Manage.py 9471 2015-11-06 07:10:07Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-11-06 15:10:07 +0800 (週五, 06 十一月 2015) $
# $Revision: 9471 $

from drip import utils
from drip import drips
from drip import admin

from drip.models import SentDrip
from django.apps import apps
from django.conf import settings
from django.db.models import Q

from Zephyrus import createLogger

logger = createLogger("Drip2", "ZephyrusDrip2.log")

def get_user_model():
    modelName = getattr(settings, "ZEPHYRUS_AUTORESPONDER_MODEL", "User")
    if modelName == "User":
        try:
            from django.contrib.auth import (
                get_user_model as django_get_user_model)
            User = django_get_user_model()
        except ImportError:
            from django.contrib.auth.models import User
        return User
    else:
        modelClass = apps.get_model(modelName)
        return modelClass

utils.get_user_model = get_user_model
drips.get_user_model = get_user_model
admin.get_user_model = get_user_model

class DripBase2(drips.DripBase):
    def apply_queryset_rules(self, qs):
        logger.info("Use objects: %s" % qs)
        clauses = {
            'filter': [],
            'exclude': []}

        for rule in self.drip_model.queryset_rules.all():
            clause = clauses.get(rule.method_type, clauses['filter'])

            kwargs = rule.filter_kwargs(qs, now=self.now)
            clause.append(Q(**kwargs))

            qs = rule.apply_any_annotation(qs)

        if clauses['exclude']:
            qs = qs.exclude(functools.reduce(operator.or_, clauses['exclude']))
        logger.info("Clauses: %s" % clauses)
        qs = qs.filter(*clauses['filter'])
        return qs

    def send(self):
        if not self.from_email:
            self.from_email = getattr(
                settings, 'DRIP_FROM_EMAIL', settings.DEFAULT_FROM_EMAIL)
        MessageClass = drips.message_class_for(self.drip_model.message_class)

        count = 0
        for user in self.get_queryset():
            message_instance = MessageClass(self, user)
            try:
                result = message_instance.message.send()
                if result:
                    SentDrip.objects.create(
                        drip=self.drip_model,
                        user=user,
                        from_email=self.from_email,
                        from_email_name=self.from_email_name,
                        subject=message_instance.subject,
                        body=message_instance.body
                    )
                    count += 1
            except Exception as e:
                logger.error(
                    "Failed to send drip %s to user %s: %s" % (
                        self.drip_model.id, user, e))
        logger.info("Total send: %d emails." %count)
        return count

drips.DripBase = DripBase2
