#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 10574 2017-11-29 03:26:17Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-11-29 11:26:17 +0800 (週三, 29 十一月 2017) $
# $Revision: 10574 $

import os
import shutil
import zipfile
import json
import hashlib

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, STATIC_DIR_PATH, 
    IMAGES_DIR_PATH, ROOT_DIR_PATH, FIXTURES_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "CreateZip.log")

class Command(BaseCommand):

    help = 'Create zip file to destination folder.'
    
    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="destination folder")
        parser.add_argument(
            '-o', '--onlyTemplate', 
            action='store_true',
            help="Only output template zip. Not have template shop info")
            
        parser.add_argument(
            '-n', '--templateName', 
            type=str, default='template',
            help="Use the name to create template zip name.")

    def handle(self, *args, **options):
        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

            content = ''
            for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
                for temp in files:
                    with open(os.path.join(root, temp)) as f:
                        htmlContent = f.read()
                    htmlContent = htmlContent.replace(
                        "<!--### include _tracking.html ###-->",
                        "{% include '_tracking.html' %}")
                    with open(os.path.join(root, temp), 'wb') as f:
                        f.write(htmlContent.encode('utf8'))
                    content += htmlContent
            data['checksum'] = hashlib.md5(content).hexdigest()

            upc = data['upc']
            complexity = data['complexity']

            with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
                line = json.dumps(data)
                f.write(line)

            context = Context({'upc': upc, 'complexity': complexity})
            temp = get_template('boilerplate/html/Tracking.html')
            content = temp.render(context)
            with open(os.path.join(
                TEMPLATES_DIR_PATH, '_tracking.html'), 'wb') as f:
                f.write(content.encode('utf8'))
                
        templateName = options['templateName']

        zip = zipfile.ZipFile(
            os.path.join(ROOT_DIR_PATH, '%s.zip' % templateName), mode='w')

        logger.info("-----Start copy templates-----")
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for f in files:
                path = os.path.join(root, f)
                dst = "./templates/%s" % f
                logger.info("Zip " + path)
                zip.write(path, dst)
        
        
        index = len(STATIC_DIR_PATH) + 1
        for root, dirs, files in os.walk(STATIC_DIR_PATH):
            for f in files:
                path = os.path.join(root, f)
                
                dst = "./static/%s" % path[index:]
                logger.info("Zip " + path)
                zip.write(path, dst)
        for root, dirs, files in os.walk(FIXTURES_DIR_PATH):
            for f in files:
                path = 'fixtures/%s' % f
                logger.info("Zip " + path)
                zip.write(path)

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            context = Context({'upc': upc,})
        else:
            context = Context({'upc': None,})
        temp = get_template('boilerplate/py/setup.py')
        content = temp.render(context)
        with open(os.path.join(ROOT_DIR_PATH, 'setup.py'), 'wb') as f:
            f.write(content.encode('utf8'))
            
        temp = get_template('boilerplate/txt/README.txt')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'README.txt'), 'w') as f:
            f.write(content.encode('utf8'))

        zip.write('./README.txt')
        logger.info("Zip README.txt")
        
        zip.write('./setup.py')
        logger.info("Zip setup.py")

        zip.close()

        dst = options['path']

        if not options['onlyTemplate']:
            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                zip = zipfile.ZipFile(
                    os.path.join(dst, '%s.zip' % data['upc']), mode='w')
                zip.write('info.json')
            else:
                zip = zipfile.ZipFile(
                    os.path.join(dst, '%s.zip' % 'TemplateShop'), mode='w')
            
            for root, dirs, files in os.walk(IMAGES_DIR_PATH):
                for file in files:
                    path = 'images/%s' % file
                    logger.info("Zip " + path)
                    zip.write(path)
                    
            zip.write('%s.zip' % templateName)
            zip.close()
        else:      
            shutil.copyfile(
                './%s.zip' % templateName, 
                os.path.join(dst, '%s.zip' % templateName))
        
        if os.path.exists(FIXTURES_DIR_PATH):
            shutil.rmtree(FIXTURES_DIR_PATH)
        if os.path.exists(IMAGES_DIR_PATH):
            shutil.rmtree(IMAGES_DIR_PATH)
        if os.path.isfile('./README.txt'):
            os.remove('./README.txt')
        if os.path.isfile('./setup.py'):
            os.remove('./setup.py')
        if os.path.isfile('./info.json'):
            os.remove('./info.json')
        if os.path.isfile('./%s.zip' % templateName):
            os.remove('./%s.zip' % templateName)
        
        logger.info('-----All OK!-----')
