#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: settings.py 10268 2017-09-05 05:59:07Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-09-05 13:59:07 +0800 (週二, 05 九月 2017) $
# $Revision: 10268 $

"""
Django settings for LandingPage project.

Generated by 'django-admin startproject' using Django 1.8.14.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

gettext = lambda s: s


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '-1evj*zt(60#q+u=-iy4sc7%f_a&tmrtox%salcf4a!^(49d^l'

# from Iuno import DEVELOPMENT, STAGE, PRODUCTION
DEVELOPMENT = 1
STAGE = 2
PRODUCTION = 3

APP_VERSION = "1.0.4." + "$Revision: 10268 $"[11:-2]

SERVER_MODE = (DEVELOPMENT if 'SERVER_MODE' not in os.environ else
               locals()[(os.environ['SERVER_MODE'])])

# DEBUG = False
# DEBUG = True
DEBUG = True if SERVER_MODE not in (STAGE, PRODUCTION) else False

TEMPLATE_DEBUG = True

ALLOWED_HOSTS = [
    '127.0.0.1', 
    'localhost', 
    '.django-cms-themes.com',
    '.django-cms-templates.com',
]

# Application definition

INSTALLED_APPS = (
    'djangocms_admin_style',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'django.contrib.sites',
    'django.contrib.sitemaps',
    'django.contrib.staticfiles',
    'django.contrib.messages',
    'cms',
    'menus',
    'sekizai',
    'treebeard',
    'djangocms_text_ckeditor',
    'djangocms_style',
    'djangocms_column',
    'filer',
    'easy_thumbnails',
    'cmsplugin_filer_image',
    'cmsplugin_filer_file',
    'cmsplugin_filer_folder',
    'cmsplugin_filer_teaser',
    'cmsplugin_filer_utils',
    'cmsplugin_filer_video',
    'djangocms_googlemap',
    'djangocms_inherit',
    'djangocms_link',
    
    'reversion',
    
    'Iuppiter.test',
    'Zephyrus.boilerplate',
)


MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    
    'cms.middleware.utils.ApphookReloadMiddleware',
    'cms.middleware.user.CurrentUserMiddleware',
    'cms.middleware.page.CurrentPageMiddleware',
    'cms.middleware.toolbar.ToolbarMiddleware',
    'cms.middleware.language.LanguageCookieMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.common.CommonMiddleware',
)

ROOT_URLCONF = 'LandingPage.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates'),],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                
                'sekizai.context_processors.sekizai',
                'cms.context_processors.cms_settings',
            ],
        },
    },
]

def getCMSTemplates():
    templates = []
    
    path = TEMPLATES[0]['DIRS'][0]
    index = None
            
    for template in os.listdir(path):
        if template.lower() == 'index.html':
            index = template
            continue
        templates.append((template, template))
    
    if index:
        return [(index, index),] + templates
    else:
        return templates

CMS_TEMPLATES = getCMSTemplates()

WSGI_APPLICATION = 'LandingPage.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'volumes', 'db.sqlite3'),
    }
}


# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'zh-hant'

TIME_ZONE = 'Asia/Taipei'

USE_I18N = True

USE_L10N = True

USE_TZ = True

LANGUAGES = (
    ('zh-hant', gettext('zh-hant')),
)

CMS_LANGUAGES = {
    'default': {
        'public': True,
        'hide_untranslated': False,
        'redirect_on_fallback': True,
    },
    1: [
        {
            'public': True,
            'code': 'zh-hant',
            'hide_untranslated': False,
            'name': gettext('zh-hant'),
            'redirect_on_fallback': True,
        },
    ],
}

DJANGOCMS_STYLE_CHOICES = ['main-image', 'minor-image', 'headline']

STATIC_URL = '/static/'
MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')
if DEBUG:    
    STATICFILES_DIRS = (
        os.path.join(BASE_DIR, 'static'),
    )
else:
    STATIC_ROOT = os.path.join(BASE_DIR, 'static')

SITE_ID = 1

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

THUMBNAIL_PROCESSORS = (
    'easy_thumbnails.processors.colorspace',
    'easy_thumbnails.processors.autocrop',
    'filer.thumbnail_processors.scale_and_crop_with_subject_location',
    'easy_thumbnails.processors.filters'
)

EMAIL_USE_TLS = True
EMAIL_HOST = 'mail.nuwainfo.com'
EMAIL_PORT = 587
EMAIL_HOST_USER = 'test@nuwainfo.com'
EMAIL_HOST_PASSWORD = 'test25025529'
DEFAULT_FROM_EMAIL = 'test@nuwainfo.com'

if DEBUG:
    SEND_TO = ['lavender15963j@gmail.com',]
else:
    SEND_TO = ['bear@nuwainfo.com', 'bear@tracedig.com']
    
CKEDITOR_SETTINGS = {
    'language': '{{ language }}',
    'toolbar_CMS': [
        ['cmsplugins',],
        
        ['Source', '-', 'Save', 'NewPage', 'DocProps', 'Preview', 'Print', '-',
         ' Templates'],
        ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 
         'Redo'],
        ['Find', 'Replace', '-', 'SelectAll', '-', 'SpellChecker', 'Scayt'],
        ['Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField'],
        ['Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', 
         '-', 'RemoveFormat'],
        ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-', 
         'Blockquote', 'CreateDiv', '-', 'JustifyLeft', 'JustifyCenter', 
         'JustifyRight', 'JustifyBlock', '-', 'BidiLtr', 'BidiRtl'] ,
        ['Link', 'Unlink', 'Anchor'],
        ['Image', 'Flash', 'Table', 'HorizontalRule', 'Smiley', 
         'SpecialChar', 'PageBreak', 'Iframe'] ,
        ['Styles', 'Format', 'Font', 'FontSize'],
        ['TextColor', 'BGColor'] ,
        ['Maximize', 'ShowBlocks', '-', 'About'],
    ],
    'skin': 'moono',
}