#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10914 2018-03-21 13:34:21Z David $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-21 21:34:21 +0800 (週三, 21 三月 2018) $
# $Revision: 10914 $

from django.conf.urls import url, include, patterns

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """

    # Theophrastus newsletter document url
    if 'Theophrastus.document' in settings.INSTALLED_APPS:
        urlpatterns += patterns('',
            url(r'^admin/', include('Theophrastus.document.urls')),
        )

    # Theophrastus newsletter urls
    urlpatterns += patterns('',
        url(r'^newsletters/', include('Theophrastus.urls')),
    )
    
    # Tinymic editor.
    if 'Theophrastus.editor' in settings.INSTALLED_APPS:
        urlpatterns += patterns('',
            url(r'^tinymce/', include('tinymce.urls')),
        )