#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 10827 2018-03-11 15:11:03Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-11 23:11:03 +0800 (週日, 11 三月 2018) $
# $Revision: 10827 $

from django.conf.urls import url, patterns

from Theophrastus.cloud import views

urlpatterns = patterns('',
    url(r'^bounces/$', views.getBounces,
        name='Theophrastus.cloud.getBounces'),
    url(r'^complains/$', views.getComplains,
        name='Theophrastus.cloud.getComplains'),
    url(r'^deliveries/$', views.getDeliveries,
        name='Theophrastus.cloud.getDeliveries'),
    url(r'^verify/$', views.verifyEmailAddress,
        name='Theophrastus.cloud.ajax.verifyEmailAddress'),
    url(r'^verify/delete/$', views.deleteVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.deleteVerifiedEmailAddress'),
    url(r'^verify/check/$', views.checkVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.checkVerifiedEmailAddress'),

    url(r'^notificationTopic/set/$', views.setNotificationTopic,
        name='Theophrastus.cloud.ajax.setNotificationTopic'),
    
    # resend error contact.
    url(r'^newsletters/resend/(?P<newsletterId>\w+)',
        views.resendErrorContact, name='resendErrorContact'),
    # view error details
     url(
        r'^tracking/historic/(?P<slug>[-\w]+)/errors/'
        r'(?P<contactMailingStatusId>\w+)',
        views.viewErrorDetails,
        name='Theophrastus.cloud.views.viewErrorDetails'),

)
