#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 10762 2018-02-02 07:47:39Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-02-02 15:47:39 +0800 (週五, 02 二月 2018) $
# $Revision: 10762 $

from django.conf.urls import url, patterns

from Theophrastus.integration import views

urlpatterns = patterns('',
    url(r'^statistics/display/(?P<groupId>\d+)/$',
        views.displayStatistics,
        name='Theophrastus.integration.views.displayStatistics'),
    url(r'^charts/totalRate/(?P<groupId>\d+)/$', views.getTotalRateData,
        name='Theophrastus.integration.ajax.getTotalRateData'),
    url(r'^charts/total/(?P<groupId>\d+)/$', views.getTotalData,
        name='Theophrastus.integration.ajax.getTotalData'),

    url(r'^subscribers/display/(?P<groupId>\d+)/$',
        views.displaySubscribers,
        name='Theophrastus.integration.views.displaySubscribers'),
    url(r'^subscribers/charts/history/(?P<groupId>\d+)/$',
        views.getHistory,
        name='Theophrastus.integration.ajax.getHistory'),

    url(r'^admin/groupMappingTable/groups/$',
        views.getGroups,
        name='Theophrastus.admin.integration.views.getGroups'),

    url(r'^tracking/historic/(?P<groupId>\d+)/$',
        views.getGroupHistory,
        name='Theophrastus.admin.integration.views.getGroupHistory'),
)

