#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: check_bounced_mail.py 12836 2021-04-08 06:31:19Z Lavender $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2021-04-08 14:31:19 +0800 (Thu, 08 Apr 2021) $
# $Revision: 12836 $

import logging
import imaplib
import email
import datetime
import pytz
import re
import json

import requests

from email.header import decode_header

from django.utils import timezone
from django.conf import settings
from django.core.management.base import BaseCommand, CommandError

from Iuppiter.Encoding import utf8
from Iuppiter.Logging import createLogger

logger = createLogger(__name__)

regex = r'([\w.]+\@[\w.]+)' 

NEWSLETTER_API_URL = "https://newsletter.nuwainfo.com/newsletters/newsletter/blackcontact/add/"

class Command(BaseCommand):

    def handle(self, *args, **options):
        # config 
        IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SUBJECTS = getattr(
            settings, "IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SUBJECTS", [])
            
        EMAIL_HOST = getattr(
            settings, "EMAIL_HOST", None)
        EMAIL_HOST_USER = getattr(
            settings, "EMAIL_HOST_USER", None)
        EMAIL_HOST_PASSWORD = getattr(
            settings, "EMAIL_HOST_PASSWORD", None)
            
        IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SEARCH_DAYS = getattr(
            settings, "IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SEARCH_DAYS", 1)
            
        if (not EMAIL_HOST or 
            not EMAIL_HOST_USER or 
            not EMAIL_HOST_PASSWORD):
            
            raise CommandError(
                "Please set ", 
                "'EMAIL_HOST'," 
                "'EMAIL_HOST_USER',"
                "'EMAIL_HOST_PASSWORD'"
                "in your settings.py"
            )
        
        
        # get emails
        mail = imaplib.IMAP4_SSL(EMAIL_HOST)
        mail.login(
            EMAIL_HOST_USER, EMAIL_HOST_PASSWORD)
        mail.select('inbox')
        
        runTime = timezone.now() - datetime.timedelta(days=IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SEARCH_DAYS)
        
        # 讀取當天所有信
        type, data = mail.search(
            None, utf8('(SINCE "%s")' % (runTime.strftime("%d-%b-%Y"),)))
        
        mailIdList = data[0]
        idList = mailIdList.split()
        
        emails = []
        
        payload = {}
        
        for i in idList:
            typ, data = mail.fetch(i, '(RFC822)' )

            for responsePart in data:
                if isinstance(responsePart, tuple):  
                    msg = email.message_from_string(
                        responsePart[1].decode("utf-8"))
                        
                    # subject
                    emailSubject = msg['subject']
                    emailSubject = decode_header(emailSubject)[0][0]
                    if not emailSubject in IUNO_CLOUD_NEWSLETTER_BOINCED_EMAIL_SUBJECTS:
                        continue
                    
                    # body
                    blackEmail = None
                    if msg.is_multipart():
                        for part in msg.walk(): 
                            type = part.get_content_type()
                            
                            if type == 'text/plain':
                                content = part.get_payload(decode=True)
                                if content:
                                    content = content.decode('utf-8')
                                    m = re.search(regex, content)
                                    if m:
                                        blackEmail = m.group(1)
                                     
                    # add black contact
                    if blackEmail:
                        payload[blackEmail] = {
                            "reason": "Undelivered Mail Returned to Sender",
                            "source": getattr(settings, "APP_NAME", ""),
                            "mail": EMAIL_HOST,
                        }
                        
                        logger.info("Add: %s" % blackEmail)
                       
                        # delete
                        mail.store(i, '+FLAGS', '\\Deleted')
                    else:
                        continue
        
        try:        
            requests.post(NEWSLETTER_API_URL, data=json.dumps(payload))
                    
            mail.expunge()
            mail.close()
            mail.logout()
        except Exception as e:
            logger.error(str(e))
                                    
                    
        
         