#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9438 2015-09-25 07:43:20Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 15:43:20 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9438 $

from account import views


class SignupView(views.SignupView):
    
    template_name = "member/Signup.html"
    template_name_ajax = "member/ajax/Signup.html"
    template_name_email_confirmation_sent = "member/EmailConfirmationSent.html"
    template_name_email_confirmation_sent_ajax = "member/ajax/EmailConfirmationSent.html"
    template_name_signup_closed = "member/SignupClosed.html"
    template_name_signup_closed_ajax = "member/ajax/SignupClosed.html"


class LoginView(views.LoginView):
    
    template_name = "member/Login.html"
    template_name_ajax = "member/ajax/Login.html"


class LogoutView(views.LogoutView):
    
    template_name = "member/Logout.html"


class ConfirmEmailView(views.ConfirmEmailView):
    
    def get_template_names(self):
        return {
            "GET": ["member/EmailConfirm.html"],
            "POST": ["member/EmailConfirmed.html"],
        }[self.request.method]


class ChangePasswordView(views.ChangePasswordView):
    
    template_name = "member/PasswordChange.html"


class PasswordResetView(views.PasswordResetView):
    
    template_name = "member/PasswordReset.html"
    template_name_sent = "member/PasswordResetSent.html"


class PasswordResetTokenView(views.PasswordResetTokenView):
    
    template_name = "member/PasswordResetToken.html"
    template_name_fail = "member/PasswordResetTokenFail.html"


class SettingsView(views.SettingsView):
    
    template_name = "member/Settings.html"


class DeleteView(views.DeleteView):
    
    template_name = "member/Delete.html"
    