#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Patch.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

import types

from django.conf import settings

from Theophrastus.models import Newsletter

def replaceNewsletterKeyword(content):
    """
    Insert newsletter's site url to Facebook Feed plugin.

    @param content Newsletter's content.
    """
    s = ("http://{{ domain }}{% url 'newsletter_newsletter_contact' slug=newslett"
        "er.slug uidb36=uidb36 token=token %}")
    content = content.replace('ReplaceNewsletterSiteLink', s)

    appId = settings.FACEBOOK_FEED_APP_ID
    content = content.replace('ReplaceFacebookAppId', appId)

    s = ("http://{{ domain }}{% url 'Theophrastus.facebook.feed.complete' %}")
    content = content.replace('ReplaceRedirectUri', s)

    return content

def cleanFields(self, *args, **kwargs):
    if self.pk is None:
        self.content = replaceNewsletterKeyword(self.content)

Newsletter.clean = types.MethodType(cleanFields, None, Newsletter)

from emencia.django.newsletter.utils import newsletter

from Theophrastus.Utility import trackLinks

newsletter.track_links = trackLinks
