#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: settings.py 9315 2014-03-12 10:16:17Z Bear $
#
# Copyright (c) 2014 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Bear $
# $Date: 2014-03-12 18:16:17 +0800 (週三, 12 三月 2014) $
# $Revision: 9315 $

import os
import sys

#============================================================================
# Production or Debug mode.
 
from Iuno import DEVELOPMENT, STAGE, PRODUCTION
  
SERVER_MODE = DEVELOPMENT
#============================================================================

#============================================================================
# Project settings.

APP_NAME = 'mail'
APP_VERSION = "0.3.0." + "$Revision: 9315 $"[11:-2]
 
INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.admin',
    'Iuppiter.extension',
    'Iuno.cloud.mail'
)

ROOT_URLCONF = 'mail.urls'
#============================================================================
 
#============================================================================
# Administration. 
ADMINS = (
    ('Bear', 'bear@tracedig.com'),
)
 
# Make this unique, and don't share it with anybody.
SECRET_KEY = 'a8vca0)a2kvj_dp_egxvo$)1k4wn#l-j3ns61*y!bmxst73f9^'
#============================================================================
 
#============================================================================
# Email.
 
EMAIL_BACKEND = 'Iuno.cloud.mail.EmailBackend'
#============================================================================
 
#============================================================================
# AWS.
 
if SERVER_MODE == DEVELOPMENT:
    pass # Do nothing.
else:
    # http://code.google.com/p/boto/wiki/BotoConfig
    botoCfg = os.path.abspath(os.path.join(os.path.dirname(__file__), '.boto'))
    print botoCfg
    if not os.path.exists(botoCfg):
        raise RuntimeError('You must setup .boto file to store AWS credentials '
                           'that has SES send authorization.')
    os.environ['BOTO_CONFIG'] = botoCfg
#============================================================================
 
#============================================================================
# Iuno.cloud.
 
IUNO_CLOUD_ENABLE = True
IUNO_CLOUD_QUEUE_SETTINGS = {
    'preferred': {
        'Nuwa': ('mq.nuwainfo.com',),
    },
}
IUNO_CLOUD_SERVICES = ('queue', 'mail', 'browser') 
# IUNO_CLOUD_LOGGING_SETTINGS = {
#     'project': APP_NAME,
#     #'force': True,
# }
 
IUNO_CLOUD_LOGGING_FILE = os.path.join(os.path.dirname(__file__), 'mail.log')
#============================================================================
 
import Iuno
Iuno.attachSettings(locals())

BASE_DIR = os.path.dirname(os.path.dirname(__file__))
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

