#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9439 2015-09-25 08:01:30Z Eric $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2015-09-25 16:01:30 +0800 (Fri, 25 Sep 2015) $
# $Revision: 9439 $

from django.contrib import auth
from Iuppiter.Service import BaseService

from Iuppiter.Model import ServiceManager

class AbstractMemberService(BaseService):
    """
    Service to provide member related API.
    """
    def __init__(self):
        """
        Constructor.
        """
        super(AbstractMemberService, self).__init__((auth.models,))

     
    def createUser(self, _obj=None, **kws):
        if _obj:
            _obj.save()
            return _obj
        else:
            return auth.models.User.objects.create_user(**kws)

