#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: RequestTest.py 9621 2016-04-06 13:36:10Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-06 21:36:10 +0800 (Wed, 06 Apr 2016) $
# $Revision: 9621 $
"""
Test Request webkit implementation.
"""

import os
#import sys
#p = os.path.abspath(os.path.join(os.path.dirname(__file__),
#                                 '..', '..', '..', '..'))
#sys.path.insert(0, p)

import unittest

from Iuno.tests.browser.RequestTestBase import _RequestTest

class RequestTest(_RequestTest):
    """
    Test case for Request.
    """

    ASSERT_DATA_DIR = os.path.dirname(__file__)

    def do(self, _url, options=None):
        """
        Do fetch.

        @param _url URL.
        @param options Options.
        @return Result.
        """
        return super(RequestTest, self).do(_url, 'webkit', options=options)

    def testSingleThread(self):
        """
        Test with single thread case (simplest case).
        """
        if not hasattr(self, 'ASSERT_DATA_DIR'):
            return

        _url = self.TEST_HOST_URL + '/'
        result = self.do(_url)

        self.assertEqual(result.url, _url)
        #self.assertEqual(result.lastModified, '11/20/2004 07:16:26')
        self.assertEqual(result.content,
            "<html><head></head><body><h1>It works!</h1></body></html>")

    import re
    styleRE = re.compile('(style=".*")')
    extRE1 = re.compile('(ext-ie\d+)')
    extRE2 = re.compile('(ext-gen\d+)')

    def _nz(self, html):
        """
        Normalize got HTML source (strip \r, \n).

        @param html HTML source.
        @return Normalized source.
        """
        try:
            from tidylib import tidy_document
            document, errors = tidy_document(html, options={
                "output-xhtml": 1,
                "doctype": "omit",
                "lower-literals": 1,
                "sort-attributes": "alpha",
                "wrap-sections": 0,
                "wrap": 0,
                "drop-empty-paras": 1,
                "force-output": 1,
                "hide-comments": 1,
                "no-newline": 1,
                "strip-scripts": 1,
                "strip-styles": 1,
            })
            return self.extRE1.sub('', self.extRE2.sub('', document))
        except ImportError:
            z = html.replace('\r', '').replace('\n', '')
            z = self.styleRE.sub('', z)
            return self.extRE1.sub('', self.extRE2.sub('', z))

    def testPost(self):
        result = self.do('http://httpbin.org/post', options={
            'post': {
                'abc': 123,
                'def': '+-*/',
            },
        })

        self.assertTrue('abc=123&amp;def=%2B-%2A%2F' in result.content)

    def testCookies(self):
        super(RequestTest, self)._testCookies()

    def testScript(self):
        super(RequestTest, self)._testScript()

if __name__ == '__main__':
    unittest.main()
