#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 9742 2017-02-08 01:01:19Z David $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $ (last)
# $Date: 2017-02-08 09:01:19 +0800 (Wed, 08 Feb 2017) $
# $Revision: 9742 $

from django.test import TestCase

from Iuno import member

class TestAttachSettings(TestCase):
    
    def testSettingsContent(self):
        
        settingsContent = {
            'AUTHENTICATION_BACKENDS' : (
            ),
            'INSTALLED_APPS' : (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),
            'MIDDLEWARE_CLASSES' : (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                ('django.contrib.auth.middleware.'
                 'SessionAuthenticationMiddleware'),
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.django.'
                                'DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                             'messages'),
                        ],
                    },
                },
            ],
            'FACEBOOK_APP_ID' : '123', 
            'FACEBOOK_API_SECRET' : '321',
            'GOOGLE_OAUTH2_CLIENT_ID' : '789',
            'GOOGLE_OAUTH2_CLIENT_SECRET' : '987', 
            'DATABASES' : {
                'default': {
                    'ENGINE': 'django.db.backends.sqlite3',
                    'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
                }
            },     
        }
        
        member.attachSettings(settingsContent)
        
        templatesSettings = {
            'TEMPLATES' : [
                {
                    'BACKEND': ('django.template.backends.'
                                'django.DjangoTemplates'),
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            ('django.contrib.messages.context_processors.'
                            'messages'),
                            "account.context_processors.account",
                            "django.core.context_processors.request", 
                            "pinax_theme_bootstrap.context_processors.theme",
                            ("social.apps.django_app.context_processors."
                             "backends"),
                            ("social.apps.django_app.context_processors."
                            "login_redirect"),
                        ],
                    },
                },
            ],
        }
        
        self.assertEqual(settingsContent['TEMPLATES'],
                         templatesSettings['TEMPLATES'])
        