#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 12312 2020-06-04 08:12:22Z Casey $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-06-04 16:12:22 +0800 (Thu, 04 Jun 2020) $
# $Revision: 12312 $
import datetime
from django.db import models
from django.utils.translation import gettext_lazy as _

# Create your models here.

class MaintenanceHistory(models.Model):

    date = models.DateTimeField(verbose_name=_(u"Date"))
    status = models.BooleanField(default=False, verbose_name=_(u"Status"))

    class Meta:
        verbose_name = _('History')
        verbose_name_plural = _('Historys')

class MaintenanceSetting(models.Model):

    status = models.BooleanField(default=False, verbose_name=_(u"Status"))
    fixedUI = models.BooleanField(default=True, verbose_name=_(u"Fixed UI"))
    openFrontEnd = models.BooleanField(default=False, verbose_name=_(u"Open Front-End"))


    def save(self, *args, **kws):
        date = datetime.datetime.now()
        status = self.status
        MaintenanceHistory.objects.create(date=date, status=status)

        super(MaintenanceSetting, self).save(*args, **kws)

    class Meta:
        verbose_name = _('Setting')
        verbose_name_plural = _('Settings')
