#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_templates.py 10389 2017-10-22 05:43:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-10-22 13:43:34 +0800 (週日, 22 十月 2017) $
# $Revision: 10389 $

import os
import sys
import shutil
import datetime
import hashlib
import zipfile

from django.core.management.base import BaseCommand

from Iuppiter.Util import run
from Zephyrus.boilerplate.management.commands import (
    PROJECT_MASHINES_DIR, PROJECT_MASHINES_ZIP, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "BuildProducts.log")    

class Command(BaseCommand):

    help = 'Start build all zip of template to dst folder.'
    
    def add_arguments(self, parser):
        parser.add_argument('start', type=str, help="start folder")
        parser.add_argument('output', type=str, help="output folder")

    def handle(self, *args, **options):
        startPath = options['start']
        dstPath = options['output']
        
        # create project
        machineName = hashlib.md5(
            startPath + str(datetime.datetime.now())).hexdigest()
        machinePath = self.createProject(machineName)
        templateDir = self.unzipTemplates(startPath, machineName)
        
        # build products
        currentPath = os.path.abspath(".")
        os.chdir(machinePath)
        
        try:
            env = os.environ.copy()
            del env['DJANGO_SETTINGS_MODULE']
            cmd = "python manage.py build_templates \"%s\" \"%s\" -o" % (
                    templateDir, dstPath)
            run(cmd, env=env, shell=True)
            with open(os.path.join(machinePath, 'BuildTemplates.log')) as log:
                content = log.read()
            if content:
                logger.error(content)
                return 1
            else:
                return 0
        finally:
            # remove project
            os.chdir(currentPath)
            projectPath = os.path.join(PROJECT_MASHINES_DIR, machineName)
            shutil.rmtree(projectPath)

    def createProject(self, machineName):
        if not os.path.isdir(os.path.join(PROJECT_MASHINES_DIR)):
            os.mkdir(os.path.join(PROJECT_MASHINES_DIR))
        dirName = os.path.join(PROJECT_MASHINES_DIR, machineName)
        os.mkdir(os.path.join(dirName))
        os.mkdir(os.path.join(dirName, 'Templates'))
        machinePath = os.path.join(dirName, "ProjectMachine")
        zip = zipfile.ZipFile(PROJECT_MASHINES_ZIP)
        zip.extractall(machinePath)
        zip.close()
        return machinePath

    def unzipTemplates(self, startPath, machineName):
        dirName = os.path.join(PROJECT_MASHINES_DIR, machineName)
        templateDir = os.path.join(dirName, "Templates")
        for f in os.listdir(startPath):
            templateName = os.path.splitext(f)[0]
            zip = zipfile.ZipFile(os.path.join(startPath, f))
            zip.extractall(os.path.join(templateDir, templateName))
            zip.close()
        return templateDir
