#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 10632 2017-12-11 09:38:08Z David $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-12-11 17:38:08 +0800 (Mon, 11 Dec 2017) $
# $Revision: 10632 $

from django import forms
from django.contrib import admin
from django.utils.translation import gettext as _
from django.core.urlresolvers import reverse

from emencia.django.newsletter.models import Newsletter
from emencia.django.newsletter.admin import NewsletterAdmin

from TinyMCEWidget import CustomTinyMCEWidget

class NewsletterTinyMCEForm(forms.ModelForm):

    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 150, 'rows': 80}),
        label=_("Content"))

    def clean_header_reply(self):
        """
        Validate reply value.
        """
        reply = self.cleaned_data["header_reply"]
        try:
            reply.encode()
        except UnicodeEncodeError:
            raise forms.ValidationError(
                _("Incorrect value for reply, it can only include English "
                "word, number and symbol."))
        return reply

    class Meta:
        model = Newsletter
        fields = '__all__'

class NewsletterTinyMCEAdmin(NewsletterAdmin):

    list_display = ('title', 'getMailingList', 'getServer', 'status',
                    'formatedSendingDate', 'formatedCreationDate',
                    'formatedModificationDate',
                    'historic_link', 'statistics_link')

    def getMailingList(self, obj):
        if obj:
            mailingList = obj.mailing_list
            url = reverse('admin:newsletter_mailinglist_change', args=(mailingList.id,))
            
            return u"<a href='%s'>%s</a>" % (url, mailingList.name)

    def getServer(self, obj):
        if obj:
            server = obj.server
            url = reverse('admin:newsletter_smtpserver_change', args=(server.id,))
    
            return u"<a href='%s'>%s</a>" % (url, server.name)
    
    getMailingList.short_description = _('mailing list')
    getMailingList.allow_tags = True
    getServer.short_description = _('server')
    getServer.allow_tags = True

    def formatedSendingDate(self, obj):
        return obj.sending_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedSendingDate.short_description = _('sending date')

    def formatedCreationDate(self, obj):
        return obj.creation_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedCreationDate.short_description = _('creation date')

    def formatedModificationDate(self, obj):
        return obj.modification_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedModificationDate.short_description = _('modification date')

    class Media:
        try:
            js = [
                'js/Newsletter.js',
            ]
        except AttributeError:
            pass

    form = NewsletterTinyMCEForm

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterTinyMCEAdmin)
