#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import sys
import hashlib
import platform
import six

from django.core.management.base import BaseCommand, CommandError
from django.core.management import get_commands
from django.template.loader import get_template

from Iuppiter.Logging import createLogger

logger = createLogger(__name__)

def toBytes(s):
    return s if six.PY2 else s.encode()

class Command(BaseCommand):
    
    help = 'Add cron job for the project.'
    
    def add_arguments(self, parser):
        parser.add_argument('command', type=str, help="Command")
        parser.add_argument('time', type=str, help="Time")
        parser.add_argument(
            '-c', '--commandScript', 
            action='store_true',
            help="if command is shellscript. This parameter must be add.")

    def handle(self, *args, **options):
        command = options['command']
        time = options['time']
        commandScript = options['commandScript']
        
        sysStr = platform.system()
        if sysStr == "Linux":
            # create shell
            if commandScript:
                hashData = hashlib.md5(
                        toBytes("%s %s" % (command, time))).hexdigest()
                        
                jobName = "%s_%s" % (command.split()[0], hashData)
            else:
                # 判斷 command
                if not command.split()[0] in get_commands():
                    raise ValueError(
                        "This command not in command list of the project: %s" % 
                        command)
                jobName = command.split()[0]
                command = "python manage.py %s" % command
                
            # 跳脫
            command = command.replace("'", "'\\''")
                
            temp = get_template("deploy/Cron.sh")
            c = {
                "command": command,
                "time": time,
                "jobName": jobName,
            }
            
            shell = temp.render(c).replace("\r\n", "\n")
            
            with open("%s.sh" % jobName, 'w') as f:
                f.write(shell)
            
            # execute shell
            result = os.system("chmod +x %s.sh" % jobName)
            result = os.system("./%s.sh" % jobName)
            
            if result == 0:
                logger.info(
                    "Success set '%s' '%s' to cronjob." %(command, time))
            else:
                logger.error("Error set '%s' '%s' to cronjob." %(command, time))
                
            os.remove("%s.sh" % jobName)
        else:
            logger.info("Only support for Linux.")


            
                    