# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import importlib

from django.db import migrations, models


def moveRedirectData(apps, schemaEditor):
    # No installed app with label
    #Redirect = apps.get('redirects.redirect')
    #Redirect = apps.get_model('redirects', 'Redirect')
    #Redirect = apps.get_model('django.contrib.redirects', 'Redirect')
    #Redirect = apps.get_model('Redirects', 'Redirect')
    #Redirect = apps.get_model('contrib.redirects', 'Redirect')
    models = importlib.import_module('django.contrib.redirects.models')
    Redirect = getattr(models, 'Redirect')
    
    Redirect2 = apps.get_model('redirect', 'Redirect')
    for r in Redirect.objects.all():
        # ValueError: Cannot assign "<Site: 127.0.0.1:8000>": 
        # "Redirect.site" must be a "Site" instance.
        obj = Redirect2.objects.create(
            site_id=r.site.id,
            old_path=r.old_path,
            new_path=r.new_path,
        )
        obj.save()

class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Redirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('old_path', models.CharField(help_text="This should be an absolute path, excluding the domain name. Example: '/events/search/'.", max_length=400, verbose_name='redirect from', db_index=True)),
                ('new_path', models.CharField(help_text="This can be either an absolute path (as above) or a full URL starting with 'http://'.", max_length=400, verbose_name='redirect to', blank=True)),
                ('site', models.ForeignKey(related_name='siteName', to='sites.Site')),
            ],
            options={
                'ordering': ('old_path',),
                'verbose_name': 'redirect',
                'verbose_name_plural': 'redirects',
            },
        ),
        migrations.AlterUniqueTogether(
            name='redirect',
            unique_together=set([('site', 'old_path')]),
        ),
        migrations.RunPython(moveRedirectData),
    ]
