#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (?g??, 18 ?G?? 2017) $
# $Revision: 9754 $

from django import template
from cms.templatetags.cms_tags import Placeholder, PlaceholderOptions
from classytags.arguments import Argument, MultiValueArgument
from classytags.core import Tag, Options
from classytags.arguments import Argument

from Zephyrus.boilerplate.models import AdminPlaceholder, BlockDisplayControl
register = template.Library()

class AdminPlaceholderTag(Tag):
    name = 'adminPlaceholder'
    
    options = PlaceholderOptions(
        Argument('name', resolve=False),
        MultiValueArgument('extra_bits', required=False, resolve=False),
        blocks=[
            ('endAdminPlaceholder', 'nodelist'),
        ],
    )
    
    def render_tag(self, context, name, extra_bits, nodelist=None):
        fromUrl = context['request'].path_info
        if nodelist:
            text = nodelist.render(context)
        else:
            text = ''
        obj, created = AdminPlaceholder.objects.get_or_create(
            name=name,
            fromUrl=fromUrl,
            defaults={'text': text,},
        )
        
        return obj.text
        
class BlockDisplayControlTag(Tag):
    name = 'with'
    options = Options(
        Argument('name'),
        blocks=[('endBlockDisplayControl', 'nodelist')],
    )

    def render_tag(self, context, name, nodelist):
        fromUrl = context['request'].path_info
        
        obj, created = BlockDisplayControl.objects.get_or_create(
            name=name,
            fromUrl=fromUrl,
        )
        
        if obj.display:
            text = nodelist.render(context)
        else:
            text = ''
        return text

register.tag('blockDisplayControl', BlockDisplayControlTag) 
register.tag('adminPlaceholder', AdminPlaceholderTag)