#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (g, 07  2017) $
# $Revision: 9948 $

import requests
import json

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.conf import settings
from django.utils.safestring import mark_safe
from Zephyrus.fb.models import FBFan, FBPhoto

class FanPage(object):
    def __init__(self, id, createTime, msg, img, url):
        self.id = id
        self.createTime = createTime
        self.msg = msg
        self.img = img
        self.url = url
        
def getFanPageId(accessToken, url):
    # get fan page id
    fanPageUrl = url
    if not fanPageUrl.endswith('/'):
        fanPageUrl += '/'
    req = requests.get(
        ("https://graph.facebook.com/v2.8/%s?access_token=%s&debug=all"
         "&format=json&method=get&pretty=0&suppress_http_code=1") % (
         fanPageUrl, accessToken))
    text = req.text
    fanPageId = json.loads(text)['id']
    return fanPageId

class FBFanPlugin(CMSPluginBase):
    model = FBFan
    name = _("FB Fan Page")
    render_template = "fb/FBFanPlugin.html"

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        fanPageUrl = instance.url
        fanPageId = getFanPageId(accessToken, instance.url)
        
        # get data
        query = "posts?fields=picture,message&limit=100"
        req = requests.get(
            'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
            fanPageId, query, accessToken)
            )      
        content = json.loads(req.text)['data']
        
        # create objects
        fpList = []
        for data in content:
            msg = None
            img = None
            createdTime = None
            url = None
            id = None
            if 'message' in data:
                msg = mark_safe(data['message'].replace('\n', '<br />'))
            else:
                continue
            if 'picture' in data:
                img = data['picture']
            if 'created_time' in data:
                createdTime = data['created_time']
            if 'id' in data:
                index = data['id'].index('_')
                id = data['id'][index + 1:]
                url = '%sposts/%s' % (fanPageUrl, id)
            fpList.append(FanPage(id, createdTime, msg, img, url))
            if len(fpList) == instance.limit:
                break
        
        context.update({
            'fpList': fpList,
        })
        
        return context
        
class FBPhotoPlugin(CMSPluginBase):
    model = FBPhoto
    name = _("FB Fan Photo")
    render_template = "fb/FBPhotoPlugin.html"

    def render(self, context, instance, placeholder):
        accessToken = '%s|%s' % (
            settings.SOCIAL_AUTH_FACEBOOK_KEY, 
            settings.SOCIAL_AUTH_FACEBOOK_SECRET
        )
        fanPageUrl = instance.url
        fanPageId = getFanPageId(accessToken, fanPageUrl)
              
        # get data
        query = "photos/uploaded?fields=images&limit=100"
        req = requests.get(
            'https://graph.facebook.com/v2.8/%s/%s&access_token=%s' % (
            fanPageId, query, accessToken)
            )      
        
        text = req.text
        content = json.loads(text)['data']
        
        # create objects
        imgUrlList = []
        for data in content:
            if 'images' in data:
                for data2 in data['images']:
                    if 'source' in data2:
                        imgUrlList.append(data2['source'])
                        break
            if len(imgUrlList) == instance.limit:
                break
        
        context.update({
            'imgUrlList': imgUrlList,
        })
        
        return context

plugin_pool.register_plugin(FBFanPlugin)
plugin_pool.register_plugin(FBPhotoPlugin)