#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: assign_templates.py 10389 2017-10-22 05:43:34Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-10-22 13:43:34 +0800 (週日, 22 十月 2017) $
# $Revision: 10389 $

import os
import shutil
import random
import math

from django.core.management.base import BaseCommand

from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "AssignTemplates.log")

DIR_TEMPLATES_NUMBER = 100
CHOSE_NUMBER = 20

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    
    def add_arguments(self, parser):
        parser.add_argument('start', type=str, help="start folder")
        parser.add_argument('dst', type=str, help="destination folder")
        parser.add_argument('--notCreateTxt', 
            type=bool, help="create sample txt", default=False)
        parser.add_argument('--templateNumber', 
            type=int, help="template number", default=DIR_TEMPLATES_NUMBER)
        parser.add_argument('--sampleNumber', 
            type=int, help="sample number", default=CHOSE_NUMBER)

    def handle(self, *args, **options):
        startPath = options['start']
        dstPath = options['dst']
        
        notCreateTxt = options['notCreateTxt']
        templateNumber = options['templateNumber']
        sampleNumber = options['sampleNumber']
        
        for root, dirs, files in os.walk(startPath):
            if not root == startPath:
                break

            random.shuffle(dirs)
            
            for i, d in enumerate(dirs, 0):
                dirPath = os.path.join(startPath, d)
                dirName = str(math.ceil(float(i + 1) / templateNumber))
                dst = os.path.join(dstPath, dirName, d)
                shutil.copytree(dirPath, dst)

                if not notCreateTxt:
                    if (i + 1) % templateNumber == 0:
                        with open(
                            os.path.join(dstPath, dirName, "%s.txt" % dirName),
                             'w') as txt:
                            start = int(i - templateNumber + 1)
                            end = int(i + 1)
                            randomDir = dirs[start:end]
                            
                            txt.write('-----Sample Template-----\n')
                            txt.write('\n'.join(
                                random.sample(randomDir, sampleNumber)))
                            txt.write('\n-----All Template-----\n')
                            txt.writelines('\n'.join(randomDir))
            
