#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: fix_template.py 10591 2017-12-03 05:37:16Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-12-03 13:37:16 +0800 (週日, 03 十二月 2017) $
# $Revision: 10591 $

import os
import hashlib

from django.core.management.base import BaseCommand

from Zephyrus.boilerplate.management.commands import TEMPLATES_DIR_PATH
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "FixTemplate.log")
            
class Command(BaseCommand):
    
    help = 'Fix template to no endplaceholder.'
    
    def add_arguments(self, parser):
        parser.add_argument(
            '--overwrite',
            default=False,
            help='Overwrite html or create new html file name xxxFix.html.',
        )
    
    def handle(self, *args, **options):
        try:
            from django import template
            from django.template import Context
                
            fileList = os.listdir(TEMPLATES_DIR_PATH)
            for htmlfile in fileList:
                htmlfile = os.path.join(TEMPLATES_DIR_PATH, htmlfile)
                logger.info(htmlfile)
                # preprocess
                loadTagHash = hashlib.md5(
                    "{% load cms_tags menu_tags sekizai_tags %}"
                    "{% load staticfiles %}").hexdigest()
                jsHash = "%s" % hashlib.md5(
                    "{% render_block 'js' %}").hexdigest()
                cssHash = "%s" % hashlib.md5(
                    "{% render_block 'css' %}").hexdigest()
                toolbarHash = "%s" % hashlib.md5(
                    "{% cms_toolbar %}").hexdigest()
                with open(htmlfile, 'rb') as f:
                    text = f.read()
                    text = text.replace(
                        "{% load cms_tags menu_tags sekizai_tags staticfiles %}", 
                        "{% load FakeTemplateTags %}" + loadTagHash)
                    text = text.replace("{% render_block 'css' %}", cssHash)
                    text = text.replace("{% render_block 'js' %}", jsHash)
                    text = text.replace("{% cms_toolbar %}", toolbarHash)
                    
                if options['overwrite']:
                    fileName = htmlfile
                else:
                    index = htmlfile.index('.html')
                    fileName = htmlfile[:index] + '_user.html'
                    
            
                with open(fileName, 'w') as f:
                    f.write(text)
            
                # process
                with open(fileName) as f:
                    t = template.Template(f.read())
                    replaceStr = Context({})
                    
                    text = t.render(replaceStr)
                    
                # endprocess
                text = text.replace(
                    loadTagHash, 
                    "{% load cms_tags menu_tags sekizai_tags staticfiles %}")
                text = text.replace(jsHash, "{% render_block 'js' %}")
                text = text.replace(cssHash, "{% render_block 'css' %}")
                text = text.replace(toolbarHash, "{% cms_toolbar %}")
                with open(fileName, 'wb') as f:
                    f.write(text.encode('utf8'))
        except Exception as e:
            logger.error("fix_template error:%s" % e)
            raise
            