var $j = jQuery.noConflict();

var findComments = function(el) {
    var arr = [];
    for(var i = 0; i < el.childNodes.length; i++) {
        var node = el.childNodes[i];
        if(node.nodeType === 8) {
            arr.push(node);
        } else {
            arr.push.apply(arr, findComments(node));
        }
    }
    return arr;
};

var walkDOM = function (node, tag) {
        if(node.nodeName.toUpperCase() == tag.toUpperCase()){
            return node
        };
        node = node.firstChild;
        while(node) {
            var result = walkDOM(node, tag);
            if (result){
                return result;
            };
            node = node.nextSibling;
        };
};    

var findTargetNode = function(commentNodes, commentStr, tag){
    var target;
    for(i in commentNodes){
        if(commentNodes[i].nodeValue == commentStr){
            node = commentNodes[i].nextSibling;
            while(node){
                var result = walkDOM(node, tag);
                if (result){
                    return result;
                } else {
                    node = node.nextSibling
                };
            };
        };
    };
    return null;
};

var addAttrs = function(target, attrs){
    $target = $j(target);
    for(k in attrs){
        if(k == 'class'){
            var origin = $target.attr('class');
            $target.attr('class', origin + ' ' + attrs[k]);
        }else{
            $target.attr(k, attrs[k]);
        };
    };
};

$j(document).ready(function() {
    var commentNodes = findComments(document);
    
    // Add Attr to tag

    {% for tag in tagList %}
        var {{ tag.tag }}{{ tag.md5 }} = findTargetNode(commentNodes, 'CMS:{{ tag.name }}', '{{ tag.tag }}');
        if({{ tag.tag }}{{ tag.md5 }} != null){  
            var attrs{{ tag.md5 }} = {
                {% for attr in tag.attrList %}
                    '{{ attr.name }}': '{{ attr.value }}'{% if not forloop.last%},{% endif %}
                {% endfor %}
            };
            addAttrs({{ tag.tag }}{{ tag.md5 }}, attrs{{ tag.md5 }})
        };
    {% endfor %}
});