#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FixTemplateTest.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

import os
import unittest
import logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

from Zephyrus.facebook.cms_plugins import getFanPage, getFanPhoto

DATA_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'data'))

class FanPageTest(unittest.TestCase):

    FAN_PAGE_URL = "https://business.facebook.com/nuwainfo/"
    FAN_PHOTO_URL = "https://business.facebook.com/pg/nuwainfo/photos/?tab=album&album_id=857708044700108"
    LIMIT = 0
    
    def testFanPage(self):
        pages = getFanPage(self.FAN_PAGE_URL, self.LIMIT)
        
        # 文章數
        self.assertEqual(len(pages), 19)
        
        page1 = pages[0]
        
        # 第一篇文章內文
        self.assertEqual("恭喜老爺，賀喜夫人" in str(page1.msg), True)
        
        # 第一篇文章連結
        # 讀出來會變這樣 https://www.facebook.comhttps://business.facebook.com/nuwainfo/posts/421336065003977 
        # 原因可能為所使用的網址非正式粉專而是測試粉專，稍微不太一樣
        self.assertEqual("https://business.facebook.com/nuwainfo/posts/421336065003977" in str(page1.url), True)
        
        return
        
    def testFanPhoto(self):
        photos = getFanPhoto(self.FAN_PHOTO_URL, self.LIMIT)
        
        # 圖片數
        self.assertEqual(len(photos), 4)
        
        # https://business.facebook.com/nuwainfo/photos/a.857708044700108/857708331366746/?type=3
        photo1 = photos[0]
        
        # 第一張圖連結
        self.assertEqual(
            "https://business.facebook.com/nuwainfo/photos/a.857708044700108/857708331366746/?type=3", photo1.link)
       
        return
        
        
if __name__ == '__main__':
    unittest.main()
    