#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9627 2016-04-10 14:55:05Z Eric $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-10 22:55:05 +0800 (Sun, 10 Apr 2016) $
# $Revision: 9627 $
"""
Browser backends to send requests to Iuno.browser via cloud architecture.
"""

import logging

logger = logging.getLogger(__name__)

from Iuppiter.Function import enhance

from Iuno.browser.AsyncRequest import AsyncRequest

def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'browser' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """
    from Iuppiter.DjangoUtil import extendInstalledApps
    
    extendInstalledApps(settingsLocals, (
        'Iuno.cloud.browser',
    ))
        
    # Force AsyncRequest's celery configuration read from django's.
    def __init__(f, self, *args, **kws):
        f(self, *args, **kws)
        self.celery.conf.update({
            'BROKER_URL': 'amqp://{user}:{password}'
                          '@{host}:{port}{vHost}'.format(
                           user=settingsLocals['BROKER_USER'],
                           password=settingsLocals['BROKER_PASSWORD'],
                           host=settingsLocals['BROKER_HOST'],
                           port=settingsLocals['BROKER_PORT'],
                           vHost=settingsLocals['BROKER_VHOST'],                         
                          ),
            'CELERY_RESULT_BACKEND': 'redis://:{password}'
                                     '@{host}:{port}'.format(
                                      password=
                                        settingsLocals['CELERY_REDIS_PASSWORD'],
                                      host=settingsLocals['CELERY_REDIS_HOST'],
                                      port=settingsLocals['CELERY_REDIS_PORT'],
                                    ),
            'CELERY_TASK_SERIALIZER': 'pickle',
            'CELERY_RESULT_SERIALIZER': 'pickle',
            'CELERY_ACCEPT_CONTENT': ['pickle'],
        })
        
    AsyncRequest.__init__ = enhance(AsyncRequest.__init__, __init__)
    