#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: RequestTest.py 9621 2016-04-06 13:36:10Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-06 21:36:10 +0800 (Wed, 06 Apr 2016) $
# $Revision: 9621 $
"""
Test Request curl implementation.
"""

import os
#import sys
#p = os.path.abspath(os.path.join(os.path.dirname(__file__),
#                                 '..', '..', '..', '..'))
#sys.path.insert(0, p)

import unittest

from Iuno.tests.browser.RequestTestBase import _RequestTest

class RequestTest(_RequestTest):
    """
    Test case for Request.
    """

    ASSERT_DATA_DIR = os.path.dirname(__file__)

    def do(self, _url, options=None):
        """
        Do fetch.

        @param _url URL.
        @param options Options.
        @return Result.
        """
        _options = {
            'keep': 2000,
        }

        if options:
            _options.update(options)

        return super(RequestTest, self).do(_url, 'curl', options=_options)

    def testPost(self):
        super(RequestTest, self)._testPost()

    def testCookies(self):
        super(RequestTest, self)._testCookies()

if __name__ == '__main__':
    unittest.main()
