#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ServiceTest.py 11430 2019-04-10 05:13:37Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-04-10 13:13:37 +0800 (Wed, 10 Apr 2019) $
# $Revision: 11430 $

import datetime

from django.test import TestCase

from Iuno.member import service

member = service.AbstractMemberService.getInstance()

class TestUser(TestCase):
    
    def setUp(self):
        
        member.createUser(username='john',
                          email='lennon@thebeatles.com',
                          password='johnpassword',
                          last_login=datetime.datetime.now())
        
    def testUserHandler(self):

        ifUserExist = member.checkUserExist(username='john')
        self.assertTrue(ifUserExist)        


        user = member.getUser(username='john')
        self.assertEqual(user.email, 'lennon@thebeatles.com')
        
        
        member.updateUser(user, email='test@example.com')
        self.assertEqual(member.getUser(username='john').email, 
                         'test@example.com')
        
        
        member.deleteUser(username='john')
        ifUserExist = member.checkUserExist(username='john')
        self.assertFalse(ifUserExist)
        