#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from cms.models import CMSPlugin
from aldryn_categories.models import Category
from taggit.models import Tag

from Zephyrus.blog_extension import settings as _settings

class MayLikePlugin(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    tag = models.ForeignKey(
        Tag,
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )

    catagory = models.ForeignKey(
        Category,
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )

    renderTemplate = models.CharField(
        _('Comment Template'), max_length=150,
        choices=_settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES,
        default=_settings.ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE,
    )

