#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: assign_templates.py 10628 2017-12-10 13:03:41Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-12-10 21:03:41 +0800 (週日, 10 十二月 2017) $
# $Revision: 10628 $

import os
import shutil
import zipfile
import hashlib

from django.conf import settings
from django.core.management.base import BaseCommand
from django.core.management import call_command
from cms.api import create_page

from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "Append_template.log")

def findSettings(path):
    for root, dirs, files in os.walk(path):
        for f in files:
            if f == 'settings.py':
                return os.path.join(root, f)
    return None

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    
    def add_arguments(self, parser):
        parser.add_argument('zip', type=str, help="template zip path")
        parser.add_argument('name', type=str, help="template page name")

    def handle(self, *args, **options):
        templatePath = options['zip']
        pageName = options['name']

        LANGUAGE_CODE = settings.LANGUAGE_CODE

        # copy template
        try:
            templateDir = settings.TEMPLATES[0]['DIRS'][0]
        except Exception as e:
            templateDir = 'templates'
    
        try:
            staticDir = settings.STATICFILES_DIRS[0]
        except Exception as e:
            staticDir = 'static'
            
        hashDir = hashlib.md5(templatePath).hexdigest()

        zip = zipfile.ZipFile(templatePath)
        zip.extract('template.zip', '.')
        zip.close()

        zip = zipfile.ZipFile('template.zip')
        zip.extractall(hashDir)
        zip.close()

        shutil.copytree(
            os.path.join(hashDir, 'static'), 
            os.path.join(staticDir, pageName))

        shutil.copytree(
            os.path.join(hashDir, 'templates'), 
            os.path.join(templateDir, pageName))

        # modify templates
        for f in os.listdir(os.path.join(templateDir, pageName)):
            if f.endswith('.html'):
                htmlPath = os.path.join(templateDir, pageName, f)
                with open(htmlPath, 'r') as html:
                    content = html.read()

                content = content.replace(
                    "{% with '' as CMS_STATIC_DIR %}",
                    "{% with '" + pageName + "/' as CMS_STATIC_DIR %}")

                with open(htmlPath, 'w') as html:
                    html.write(content)


        # modify settings
        settingsPath = findSettings('.')
        settingsDir = os.path.dirname(settingsPath)
        bak = os.path.join(settingsDir, 'settings.py.bak')
        if os.path.isfile(bak):
            logger.error("%s exists. failed to backup file." % bak)
            return 

        shutil.copyfile(settingsPath, bak)

        with open(settingsPath, 'r') as settingsFile:
            content = settingsFile.read()
               
        with open(settingsPath, 'w') as settingsFile: 
            content += \
'''
CMS_TEMPLATES = list(CMS_TEMPLATES)
CMS_TEMPLATES += [
    ('%s/index.html', '%s'),
    ('%s/index_content.html', '%s_content'),
]
''' % (pageName, pageName, pageName, pageName)

            settingsFile.write(content)

        # create page
        settings.CMS_TEMPLATES = list(settings.CMS_TEMPLATES)
        settings.CMS_TEMPLATES += [
            ('%s/index.html' % pageName, '%s' % pageName),
            ('%s/index_content.html' % pageName, '%s_content' % pageName),
        ]

        page = create_page(
            pageName, '%s/index_content.html' % pageName, 
            LANGUAGE_CODE, published=True)

        # pluginize
        call_command(
            'pluginize', template='index_content.html', templateDir=pageName)

