#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 10982 2018-04-16 08:14:06Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-04-16 16:14:06 +0800 (週一, 16 四月 2018) $
# $Revision: 10982 $

from django import forms

from Zephyrus.cms_oscar.models import OscarFeatured, OscarLatest
from oscar.core.loading import get_model

Product = get_model('catalogue', 'Product')

hasTags = False

if hasattr(Product, 'tags'):
    hasTags = True

    from taggit.models import Tag

    tagList = [
        (0, '------'),
    ]
    for tag in Tag.objects.all():
        tagList.append((tag.id, tag.name))

class OscarFeaturedForm(forms.ModelForm):
    if hasTags:
        tag = forms.ChoiceField(
            choices=tagList,
            required=False
        )

    def save(self, commit=True):
        obj = super(OscarFeaturedForm, self).save(commit=commit)

        if hasTags and not self.data['tag'] == 0:
            obj.tag = self.data['tag']
            obj.save()

        return obj

    class Meta:
        model = OscarFeatured
        exclude = ['tag',]

class OscarLatestForm(forms.ModelForm):
    if hasTags:
        tag = forms.ChoiceField(
            choices=tagList,
            required=False
        )

    def save(self, commit=True):
        obj = super(OscarLatestForm, self).save(commit=commit)

        if hasTags and not self.data['tag'] == 0:
            obj.tag = self.data['tag']
            obj.save()
            
        return obj

    class Meta:
        model = OscarLatest
        exclude = ['tag']
