#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 17:31:00 +0800 (Mon, 16 Jul 2018) $
# $Revision: 11172 $

import os

DEFAULTS = {
    'IUNO_CLOUD_STORAGE_GOOGLE_CREDENTIAL': os.path.join(os.path.dirname(
        os.path.realpath(__file__)), 'gos', '.credentials', 'credential.json'),
    'IUNO_CLOUD_STORAGE_GOOGLE_SCOPE': 'https://www.googleapis.com/auth/drive'
}


def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'storage' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """

    for key, val in DEFAULTS.items():
        settingsLocals.setdefault(key, val)
