#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 11771 2019-11-01 08:29:32Z Andy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-11-01 16:29:32 +0800 (週五, 01 十一月 2019) $
# $Revision: 11771 $

import os
from django.test import TestCase

from Iuno import deploy

class TestAttachSettings(TestCase):
    
    def runTest(self):
        
        settingsContent = {
            'INSTALLED_APPS': (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),

            "MIDDLEWARE_CLASSES": (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),

            "ROOT_URLCONF": 'TemplatesShop.urls',

            'DATABASES': {
                'default': {
                    'ENGINE': 'django.db.backends.sqlite3',
                    'NAME': os.path.join('BASE_DIR', 'db.sqlite3'),
                }
            },

            "DEBUG": True,

            '__file__': '/Users/Ming/Documents/Nuwa_mercurius/Projects/TemplatesShop/TemplatesShop/settings.pyc',

            "TEMPLATES": [
                {
                    'BACKEND': 'django.template.backends.django.DjangoTemplates',
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            'django.contrib.messages.context_processors.messages',
                        ],
                    },
                },
            ],

            'DEFAULT_FROM_EMAIL': 'test@nuwainfo.com',
            'BASE_DIR': 'ddd',
            "IUNO_SITE_DOMAIN_NAMES": {
                1: '127.0.0.1:8000',
                2: 'www.caramelo-jd.com',
                3: 'www.caramelo-jd.com',           
            },
            'ALLOWED_HOSTS': [],
            'SERVER_MODE': 2,
        }
        
        allowHosts = deploy.attachSettings(settingsContent, {
                1: '127.0.0.1:8000',
                2: 'www.caramelo-jd.com',
                3: 'www.caramelo-jd.com',           
            })
        
        installedAppsSettings = {
            'ALLOWED_HOSTS': ['.caramelo-jd.com'],
        }
        
        self.assertEqual(allowHosts,
                         installedAppsSettings['ALLOWED_HOSTS'])

if __name__ == "__main__":
    testAttachSettings = TestAttachSettings()
    testAttachSettings.runTest()