#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Patch.py 11526 2019-05-07 08:36:46Z Andy $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $ (last)
# $Date: 2019-05-07 17:36:46 +0900 (週二, 07 五月 2019) $
# $Revision: 11526 $
#
# Contributors:
#  Bear
#  Yachu

import hashlib
import os
import six

from django.conf import settings
from django.urls import reverse
from django.utils.html import conditional_escape 
from django.contrib.sites.shortcuts import get_current_site
from django.contrib.auth.decorators import permission_required
from django.http import HttpResponse, Http404

from django_statsd import incr

def getHashKey(keys):
    data = settings.SECRET_KEY
    for key in keys:
        data += key
        
    if six.PY3:
        hashKey = hashlib.sha256(data.encode()).hexdigest()
    else:
        hashKey = hashlib.sha256(data).hexdigest()
        
    return hashKey

def sendStatsd(request):
    referer = request.META.get('HTTP_REFERER')
    site = get_current_site(request)

    if not referer:
        raise Http404()
    if not site.domain in referer:
        raise Http404()

    imagePath = os.path.join(os.path.dirname(__file__), 'static', "1px.png")
    with open(imagePath, "rb") as f:
        image = f.read()
        
    keys = [k for k in request.GET if not k == 'checksum']
    
    hashKey = getHashKey(keys)
    
    if not hashKey == request.GET.get('checksum'):
        raise Http404()
    else:
        for key in request.GET:
            if not key == 'checksum':
                incr(key)
        return HttpResponse(image, content_type="image/png")

  
@permission_required('metrics.get_statsd', raise_exception=True)
def getStatsdImage(request):
    
    keys = [k for k in request.GET]
    
    if not keys:
        raise Http404()

    hashKey = getHashKey(keys)
    
    url = "<img src=\"%s?%s%s\"/>" % (
        reverse("sendStatsd"), "&".join(keys), "&checksum=%s" % hashKey)
    url += "\n<img src=\"{% url 'sendStatsd' %}" + "?%s%s\"/>" % (
        "&".join(keys), "&checksum=%s" % hashKey)

    return HttpResponse(conditional_escape(url))


