#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11660 2019-07-21 13:24:58Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2019-07-21 22:24:58 +0900 (週日, 21 七月 2019) $
# $Revision: 11660 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class Settings(object):

    INSTAGRAM_PHOTO_DEFAULT_TEMPLATE = \
        "instagram/Default.html"

    INSTAGRAM_PHOTO_TEMPLATES = [
        (INSTAGRAM_PHOTO_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'INSTAGRAM_PHOTO_TEMPLATES'):
        for ele in _settings.INSTAGRAM_PHOTO_TEMPLATES:
            if not ele[0] == "instagram/Default.html":
                INSTAGRAM_PHOTO_TEMPLATES.append(ele)

settings = Settings()
