#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11984 2020-03-19 12:21:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-03-19 21:21:32 +0900 (週四, 19 三月 2020) $
# $Revision: 11984 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class URL(models.Model):
    url = models.CharField(max_length=400, editable=False, db_index=True, unique=True)
    viewCount = models.PositiveIntegerField(
        verbose_name=_("View count"), default=0)
    likeCount = models.PositiveIntegerField(
        verbose_name=_("Like count"), default=0)
    commentCount = models.PositiveIntegerField(
        verbose_name=_("Comment count"), default=0)

    class Meta:
        verbose_name = _("URL")
        verbose_name_plural = _("URLs")
