#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2020 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import os
import json
import platform
import zipfile

import requests

from django.urls import reverse
from django.conf import settings

from Iuno.Version import IUNO_VERSION
from Iuppiter.Logging import createLogger
from Iuno.Util import update
from Iuno import attachSettings, DEVELOPMENT

logger = createLogger(__name__)

def importSettings(settingsDict, settings):
    settingsDict.update({k: getattr(settings, k) for k in dir(settings)})
    testSettings = {
        "SERVER_MODE": DEVELOPMENT,
        "DEBUG": True,
    }
    update(settingsDict, testSettings)
    attachSettings(settingsDict)

def downloadChromedriver():
    needDownload = False
  
    if platform.system() in ['Linux', 'Darwin']:
        if not os.path.exists("chromedriver"):
            needDownload = True
    else:
        if not os.path.exists("chromedriver.exe"):
            needDownload = True
    
    if needDownload:
        chromeVersion = requests.get("https://chromedriver.storage.googleapis.com/LATEST_RELEASE").text
            
        if platform.system() == 'Linux':
            driverZip = requests.get(
                "https://chromedriver.storage.googleapis.com/%s/chromedriver_linux64.zip" % chromeVersion).content
        elif platform.system() == 'Darwin':
            driverZip = requests.get(
                "https://chromedriver.storage.googleapis.com/%s/chromedriver_mac64.zip" % chromeVersion).content
        else:
            driverZip = requests.get(
                "https://chromedriver.storage.googleapis.com/%s/chromedriver_win32.zip" % chromeVersion).content
            
        zipPath = os.path.join("chromedriver.zip")
                   
        with open(zipPath, "wb") as f:
            f.write(driverZip)
            
        with zipfile.ZipFile(zipPath, 'r') as zip:
            zip.extractall(".")
            
        if platform.system() in ['Linux', 'Darwin']:
            os.system("chmod +x chromedriver")
            
        os.remove("chromedriver.zip")

class RemoteTestCaseMixin(object):

    TEST_URL = None
    TEST_SETTINGS = None
    
    def runTest(self):
        try:
            remoteURL = reverse("remoteTest")
        except Exception as e:
            # 如 OscarDemoTest 所 run 的環境沒有 urls.py，因此不能用 reverse
            remoteURL = "/remote/test/"
        result = requests.post(
            "%s%s" % (self.TEST_URL, remoteURL), data={"password": "25025529", "settings": self.TEST_SETTINGS})
        allData = json.loads(result.text)
        version = allData.get('IUNO_VERSION', "0.0.0.0")
        localAppVersion = getattr(settings, "APP_VERSION", None)
        remoteAppVersion = allData.get("APP_VERSION", "0.0.0.0")
        if localAppVersion:
            if [int(i) for i in localAppVersion.split(".")] > [int(i) for i in remoteAppVersion.split(".")]:
                logger.warning(
                    "Local app version is %s, but remote app version is %s." % (localAppVersion, remoteAppVersion))
        else:
            if [int(i) for i in IUNO_VERSION.split(".")] > [int(i) for i in version.split(".")]:
                logger.warning("Iuno version is %s, but latest Iuno version is %s." % (IUNO_VERSION, version))
        logger.info(allData.get('result', None))
        
        errorCount = 0
        
        for testcase in allData.get('track', []):
            if testcase.get('error', []):
                classname = testcase.get('classname', None)
                name = testcase.get('name', None)
                time = testcase.get('time', None)
                msg = '''
======================================================================
ERROR [%ss]: %s (%s)
----------------------------------------------------------------------
                ''' % (time, name, classname)
                logger.info(msg)
                for error in testcase.get('error', []):
                    logger.info("Message: ", error.get("message", None))
                    logger.info("Type: ", error.get("type", None))
                    logger.info(error.get("traceback", None))
                    errorCount += 1
        
        # has error
        self.assertEqual(0, errorCount)