#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11646 2019-07-01 01:31:33Z Andy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-07-01 09:31:33 +0800 (週一, 01 七月 2019) $
# $Revision: 11646 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

from Iuppiter.Model import BaseModelMixin

from emencia.django.newsletter.models import Newsletter, Contact

class CloudMailInformation(models.Model, BaseModelMixin):
    """
    Mail sending information.
    """
    newsletter = models.ForeignKey(Newsletter, unique=False)

    contact = models.ForeignKey(Contact, unique=False)

    # Response id for sent mail.
    messageId = models.TextField(max_length=2048)
    # Response message for sent mail.
    message = models.TextField(default='')

class NewsletterInformation(models.Model, BaseModelMixin):

    newsletter = models.ForeignKey(Newsletter)

    sync = models.BooleanField(default=True)

class ErrorMessage(models.Model):

    message =  models.CharField(max_length=2048, blank=True, null=True)

    newsletter = models.ForeignKey(Newsletter, verbose_name=_('newsletter'))

    contact = models.ForeignKey(Contact, verbose_name=_('contact'))
