#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11616 2019-06-07 02:15:46Z Andy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-06-07 10:15:46 +0800 (週五, 07 六月 2019) $
# $Revision: 11616 $

from django import forms
from django.contrib import admin
from django.utils.translation import gettext as _
from django.core.urlresolvers import reverse

from emencia.django.newsletter.models import Newsletter
# #FIXME: Django forms dependencies issues, 
# see https://code.nuwainfo.com/trac/mercurius/ticket/3022
# from emencia.django.newsletter.admin import NewsletterAdmin
from Theophrastus.newsletter_extension.admin import NewsletterExtensionAdmin \
                                                    as NewsletterAdmin
from Theophrastus.newsletter_extension.admin import NewsletterForm
from Theophrastus.newsletter_extension.models import Header, Footer
from Theophrastus.editor.forms import HeaderTinyMCEForm
from Theophrastus.editor.forms import FooterTinyMCEForm
from .TinyMCEWidget import CustomTinyMCEWidget

class NewsletterTinyMCEForm(NewsletterForm):
    def __init__(self, *args, **kwargs):
        super(NewsletterTinyMCEForm, self).__init__(*args, **kwargs)

    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 150, 'rows': 80}),
        label=_("Content"))

class NewsletterTinyMCEAdmin(NewsletterAdmin):
    form = NewsletterTinyMCEForm

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterTinyMCEAdmin)

class HeaderTinyMCEAdmin(admin.ModelAdmin):
    list_display=['title']
    form = HeaderTinyMCEForm

admin.site.unregister(Header)
admin.site.register(Header, HeaderTinyMCEAdmin)

class FooterTinyMCEAdmin(admin.ModelAdmin):
    list_display=['title']
    form = FooterTinyMCEForm

admin.site.unregister(Footer)
admin.site.register(Footer, FooterTinyMCEAdmin)

