#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_templates.py 13367 2021-12-24 04:53:31Z Mint $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Mint $
# $Date: 2021-12-24 12:53:31 +0800 (週五, 24 十二月 2021) $
# $Revision: 13367 $

import os
import sys
import shutil

import cms

from django.core.management.base import BaseCommand
from django.conf import settings

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger
from Zephyrus.boilerplate.management.commands.BlackList import BLACK_LIST

logger = createLogger(__name__, "BuildTemplates.log")

class Command(BaseCommand):

    help = 'Start build all template to dst folder.'
    args = '<start folder> <destination folder>'
    
    def add_arguments(self, parser):
        parser.add_argument('start', type=str, help="start folder")
        parser.add_argument('output', type=str, help="output folder")
        parser.add_argument(
            '-o', '--onlyTemplate', 
            action='store_true',
            help="Only output template zip. Not have template shop info")

    def handle(self, *args, **options):
        startPath = options['start']
        dstPath = options['output']

        hasError = 0
        
        for f in os.listdir(startPath):
            if f in BLACK_LIST:
                continue
            
            tempPath = os.path.join(startPath, f)
            
            dbPath = settings.DATABASES['default']['NAME']
            backupDbPath = os.path.join(ROOT_DIR_PATH, "backup.db")
            if os.path.isfile(backupDbPath):
                if os.path.isfile(dbPath):
                    os.remove(dbPath)
                shutil.copyfile(backupDbPath, dbPath)
            else:
                os.system("%s manage.py migrate --noinput" % sys.executable)
                shutil.copyfile(dbPath, backupDbPath)

            # get_template
            error = os.system(
                "%s manage.py get_template \"%s\"" % (sys.executable, tempPath))
            if not error == 0:
                logger.error(
                    "get_template error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue

            # build_boilerplate
            error = os.system(
                "%s manage.py build_boilerplate2 \"%s\"" % 
                (sys.executable, TEMPLATES_DIR_PATH))
            if not error == 0:
                logger.error(
                    "build_boilerplate2 error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue
                
            # create_pages
            error = os.system(
                "%s manage.py create_pages" % sys.executable)
            if not error == 0:
                logger.error(
                    "create_pages error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue
                
            # pluginize
            error = os.system(
                "%s manage.py pluginize" % sys.executable)
            if not error == 0:
                logger.error(
                    "pluginize error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue
                
            # fix_template
            error = os.system(
                "%s manage.py fix_template" % sys.executable)
            if not error == 0:
                logger.error(
                    "fix_template error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue

            # dumpdata
            error = os.system(
                ("%s manage.py cms_dumpdata "
                 "fixtures/initial_data.json -n") % 
                (sys.executable,))

            if not error == 0:
                logger.error(
                    "dumpdata error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue

            # create_zip
            if not options['onlyTemplate']:
                error = os.system(
                    "%s manage.py create_zip \"%s\"" % (sys.executable, dstPath))
            else:
                error = os.system(
                    "%s manage.py create_zip \"%s\" -o -n \"%s_theme\"" % (
                        sys.executable, dstPath, f))
            if not error == 0:
                logger.error(
                    "create_zip error code: %d, from template: %s" % 
                    (error, tempPath))
                hasError = 1
                continue
            