#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 13189 2021-08-04 10:31:25Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-08-04 18:31:25 +0800 (週三, 04 八月 2021) $
# $Revision: 13189 $

import six
import urllib

from django.contrib import admin
from django.utils.safestring import mark_safe

from Iuppiter.Encoding import utf8

from Zephyrus.stats import views
from Zephyrus.stats.models import URL

@admin.register(URL)
class URLAdmin(admin.ModelAdmin):
    model = URL

    list_display = ['getUrl', 'viewCount', 'likeCount', 'commentCount']
    
    def getUrl(self, obj):
        if six.PY3:
            name = urllib.parse.unquote(str(obj.url))
        else:
            name = urllib.unquote(str(obj.url))
            
        name = utf8(name).decode('utf8')
         
        return mark_safe(u"<a target='_blank' href='%s'>%s</a>" % (obj.url, name))

    getUrl.short_description = "URL"
    getUrl.admin_order_field = 'url'
    getUrl.allow_tags = True
