#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Util.py 12121 2020-04-25 14:18:25Z Trista $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $ (last)
# $Date: 2020-04-25 22:18:25 +0800 (週六, 25 四月 2020) $
# $Revision: 12121 $
"""
Utilities.
"""

def update(settingsDict, defaults, config=None):
    """
    Update settings by defaults if the key is not in settings.
    
    @param settingsDict Settings dict.
    @param defaults Defaults dict to provide default value.
    @param config Reserved.
    """
    for k, v in list(defaults.items()):
        if k not in settingsDict:
            settingsDict[k] = v
            
def determinePrintDetail(printDetail, args):
    if len(args) >= 2:
        if (args[0].endswith('manage.py')) and (args[1] == 'runserver'):
            printDetail = printDetail
        else:
            printDetail = False
            
    # if the command is not manage.py runserver(ex: cms_dumpdata), do NOT print SERVER_MODE
    else:
        printDetail = False
    
    return PrintDetail

def populateEnvToSettings(keys, settingsDict, setter=None, evalKeys=None, PrintDetail=True):
    """
    Populate value in environment variables to settings.

    @param keys Variable keys to find in environment variables.
    @param settingsDict locals() in settings.py.
    @param setter Function to decide how to set to settings.
    @param evalKeys The keys in keys arguments which its value should be eval.
    @return Set keys.
    """
    setKeys = []

    import os
    import sys
    from Iuppiter.Util import colored
    
    args = sys.argv
    PrintDetail = PrintDetail
    printDetail = determinePrintDetail(printDetail, args)

    # if the command is manage.py runserver, then print the SERVER_MODE
    
    
    for k in keys:
        if k in os.environ:
            if printDetail:
                print("%s found in environment variable, set to settings." % (
                    colored(k, 'yellow', attrs=['bold'])))
            
            v = os.environ[k]
            if evalKeys and k in evalKeys:
                v = eval(v)
                
            if setter:
                setter(k, v, settingsDict)
            else:
                settingsDict[k] = v
                
            setKeys.append(k)
            
    return setKeys

class VersionInfo(object):
    def __init__(self, version='',
                 major=None, minor=None, build=None, revision=None):
        if not version:
            self.major = major
            self.minor = minor
            self.build = build
            self.revision = revision
        else:
            major, minor, build, rev = version.split('.')
            rev = rev.strip()

            wildcard = ('?', '*')
            self.major = int(major) if major not in wildcard else None
            self.minor = int(minor) if minor not in wildcard else None
            self.build = int(build) if build not in wildcard else None
            self.revision = int(rev) if rev not in wildcard else None

    def __key(self):
        return  (self.major, self.minor, self.build, self.revision)

    def __str__(self):
        return '%d.%d.%d.%d' % self.__key()

    def __lt__(self, other):
        if isinstance(other, str):
            return self.__lt__(VersionInfo(other))

        if self.revision is not None and other.revision is not None:
            if self.revision < other.revision:
                return True

        if self.major is not None and other.major is not None:
            if self.major < other.major:
                return True

        if self.minor is not None and other.minor is not None:
            if self.minor < other.minor:
                return True

        if self.build is not None and other.build is not None:
            if self.build < other.build:
                return True

        return False

    def __gt__(self, other):
        if self.__eq__(other) or self.__lt__(other):
            return False
        else:
            return True

    def __eq__(self, other):
        if isinstance(other, str):
            return self.__eq__(VersionInfo(other))
        elif not isinstance(other, VersionInfo):
            return False
        else:
            return self.__key() == other.__key()

    def __ne__(self, other):
        if isinstance(other, str):
            return self.__ne__(VersionInfo(other))
        else:
            return not self.__eq__(other)

    def __hash__(self):
        return hash(self.__key())
