#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_templates.py 13399 2022-03-28 10:41:43Z Jacky $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jacky $
# $Date: 2022-03-28 18:41:43 +0800 (Mon, 28 Mar 2022) $
# $Revision: 13399 $

import os
import sys
import shutil

import cms

from django.core.management import call_command
from django.core.management.base import BaseCommand
from django.conf import settings

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger
from Zephyrus.boilerplate.management.commands.BlackList import BLACK_LIST

logger = createLogger(__name__, "BuildTemplates.log")

class Command(BaseCommand):

    help = 'Start build all template to dst folder.'
    args = '<start folder> <destination folder>'

    def add_arguments(self, parser):
        parser.add_argument('start', type=str, help="start folder")
        parser.add_argument('output', type=str, help="output folder")
        parser.add_argument(
            '-o', '--onlyTemplate',
            action='store_true',
            help="Only output template zip. Not have template shop info")

    def handle(self, *args, **options):
        startPath = options['start']
        dstPath = options['output']

        hasError = 0

        for f in os.listdir(startPath):
            if f in BLACK_LIST:
                continue

            tempPath = os.path.join(startPath, f)

            dbPath = settings.DATABASES['default']['NAME']
            backupDbPath = os.path.join(ROOT_DIR_PATH, "backup.db")
            if os.path.isfile(backupDbPath):
                if os.path.isfile(dbPath):
                    os.remove(dbPath)
                shutil.copyfile(backupDbPath, dbPath)
            else:
                call_command("migrate", "--noinput")
                shutil.copyfile(dbPath, backupDbPath)

            # get_template
            try:
                call_command("get_template", tempPath)
            except Exception as e:
                logger.error("Error: when use command 'get_template': %s" % e)
                hasError = 1
                continue

            # build_boilerplate
            try:
                call_command("build_boilerplate2", TEMPLATES_DIR_PATH)
            except Exception as e:
                logger.error("Error: when use command 'build_boilerplate2': %s" %e)
                hasError = 1
                continue

            # create_pages
            try:
                call_command("create_pages")
            except Exception as e:
                logger.error("Error: when use command 'create_pages': %s" % e)
                hasError = 1
                continue

            # pluginize
            try:
                call_command("pluginize")
            except Exception as e:
                logger.error("Error: when use command 'pluginize': %s" % e)
                hasError = 1
                continue

            # fix_template
            try:
                call_command("fix_template")
            except Exception as e:
                logger.error("Error: when use command 'fix_template': %s" % e)
                hasError = 1
                continue

            # dumpdata
            try:
                call_command("cms_dumpdata", "fixtures/initial_data.json", "-n")
            except Exceptio as e:
                logger.error("Error: when use command 'cms_dumpdata': %s" % e)
                hasError = 1
                continue

            # create_zip
            try:
                if not options['onlyTemplate']:
                    call_command("create_zip", dstPath)
                else:
                    call_command("create_zip", dstPath, "-o", "-n", f"{f}_theme")
            except Exception as e:
                logger.error("Error: when use command 'create_zip': %s" % e)
                hasError = 1
                continue
