#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 12819 2021-03-30 02:12:19Z Becca $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Becca $ (last)
# $Date: 2021-03-30 10:12:19 +0800 (Tue, 30 Mar 2021) $
# $Revision: 12819 $

from django.db import models
from django.utils.translation import ugettext as _

from cms.models import CMSPlugin
from oscar.core.loading import get_model
# from taggit.models import Tag

from Zephyrus.cms_oscar import settings

Category = get_model('catalogue', 'Category')
ConditionalOffer = get_model('offer', 'ConditionalOffer')

OR = 1
AND = 2

METHODS = [
    (OR,  _('OR')),
    (AND,  _('AND')),
]


class OscarFeatured(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    filterMethod = models.IntegerField(
        _('Filter Method'), choices=METHODS, default=OR)

    renderTemplate = models.CharField(
        'Featured Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_FEATURED_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE,
    )
    
    tag = models.CharField(
        max_length=200,
        default=None,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by tag.")
    )

    catagory = models.ManyToManyField(
        Category,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by category.")
    )
    
class OscarLatest(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    filterMethod = models.IntegerField(
        _('Filter Method'), choices=METHODS, default=OR)

    renderTemplate = models.CharField(
        'Latest Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_LATEST_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE,
    )

    tag = models.CharField(
        max_length=200,
        default=None,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by tag.")
    )
    
    catagory = models.ManyToManyField(
        Category,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by category.")
    )

class OscarBestSeller(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    filterMethod = models.IntegerField(
        _('Filter Method'), choices=METHODS, default=OR)

    renderTemplate = models.CharField(
        'BestSeller Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_BESTSELLER_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_BESTSELLER_DEFAULT_TEMPLATE,
    )
    
    tag = models.CharField(
        max_length=200,
        default=None,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by tag.")
    )

    catagory = models.ManyToManyField(
        Category,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by category.")
    )


class OscarOffer(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    renderTemplate = models.CharField(
        'Offer Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_OFFER_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE,
    )

    offer = models.ManyToManyField(
        ConditionalOffer,
    )

    def copy_relations(self, oldinstance):
        self.offer = oldinstance.offer.all()