#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 13223 2021-08-11 15:06:37Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-08-11 23:06:37 +0800 (Wed, 11 Aug 2021) $
# $Revision: 13223 $

import json
import requests
import urllib

import six

from django.utils.http import urlquote
from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _
from django.conf.urls import url, include

from Iuppiter.DjangoUtil import DJANGO_VERSION

if six.PY3:
    from urllib.parse import urlparse
else:
    from urlparse import urlparse

class Settings(object):
    # Facebook Nuwa Blog APP
    ZEPHYRUS_FACEBOOK_DEFAULT_GET_ACCESS_TOKEN_URL = "https://www.nuwainfo.com"
    ZEPHYRUS_FACEBOOK_DEFAULT_SECRET_KEY = "k*ohwp_!xr!rz*+6b2fpff%&5tw!nyh__^#y0%w#53k11#nh9p"
    ZEPHYRUS_FACEBOOK_DEFAULT_PASSWORD = "@%)@5529"
    ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID = "1435073943305111"
    ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET = "1f0ba7a626695ee0c5419627c2d0a8b9"
    ZEPHYRUS_FACEBOOK_WEBHOOK_VERIFY_TOKEN = "25025529"
    ZEPHYRUS_FACEBOOK_PROXY = { 
        "http": "http://Nuwa:25025529@35.229.140.3:8888/", 
        "https": "http://Nuwa:25025529@35.229.140.3:8888/", 
    }
    
    
    ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE = \
        "facebook/FacebookFanPlugin.html"
    ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE = \
        "facebook/FacebookPhotoPlugin.html"

    ZEPHYRUS_FACEBOOK_FAN_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_FAN_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_FAN_TEMPLATES:
            if not ele[0] == "facebook/FacebookFanPlugin.html":
                ZEPHYRUS_FACEBOOK_FAN_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES:
            if not ele[0] == "facebook/FacebookPhotoPlugin.html":
                ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES.append(ele)
   
SCOPE = ["manage_pages", "pages_show_list"]  
MANAGE_PAGES_STATE = "manage_pages"
    
settings = Settings()

def getCommentURL(commentId, 
    key=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, 
    value=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET):

    accessToken = '%s|%s' % (key, value)
    url = ("https://graph.facebook.com/v3.3/"
           "%s?fields=permalink_url&access_token=%s") % (commentId, accessToken)
    result = requests.get(url)
    data = json.loads(result.text)

    url = data.get("permalink_url")

    if url:
        url = urlparse(url)
        return "%s://%s%s" % (url.scheme, url.netloc, url.path)
    else:
        return None

def getAPIData(url, fieldName, 
    key=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, 
    value=settings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET):

    accessToken = '%s|%s' % (key, value)
    
    apiUrl = (
        'https://graph.facebook.com/v3.3/'
        '?id=%s&fields=engagement&access_token=%s' % (
        urlquote(url), accessToken)
    )
    
    data = json.loads(requests.get(apiUrl).text)
    
    if fieldName == "comment_count":
        # comment_plugin_count
        fieldName = "comment_plugin_count"
        return data.get("engagement", {}).get(fieldName, None)
    if fieldName == "share_count":
        # like
        fieldName = 'reaction_count'
        reaction = data.get("engagement", {}).get(fieldName, 0)
        fieldName = "comment_count"
        comment = data.get("engagement", {}).get(fieldName, 0)
        fieldName = 'share_count'
        share = data.get("engagement", {}).get(fieldName, 0)
        return reaction + share + comment
    return data.get("engagement", {}).get(fieldName, None)

def patterns(prefix, *args): 
    if DJANGO_VERSION >= 11100: # django >= 1.11
        return list(args)
    else:
        from django.conf.urls import patterns as _patterns
        
        return _patterns(prefix, *args)

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """
    urlpatterns += patterns('',
        url(r'^', include('Zephyrus.facebook.urls')),
    )

