#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import base64

from django import forms
from django.conf import settings

from Iuppiter.Encryption import Encryptor
from Iuno.cloud.sms.models import Token

class TokenAdminForm(forms.ModelForm):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['description'].required = False

    class Meta:
        model = Token
        fields = ['name', 'token', 'username', 'password', 'description']
        widgets = {
            'password': forms.PasswordInput(),
        }
        
    def clean_password(self):
        password = self.cleaned_data['password'] 
        password = password.encode()
        encryptor = Encryptor(settings.SECRET_KEY.encode())
        secret = encryptor.encrypt(password)  
        secret = base64.urlsafe_b64encode(secret)
        
        return secret
    