from django.conf.urls import url
from django.utils.translation import gettext_lazy as _

from oscar.core.application import OscarConfig
from oscar.core.loading import get_class, get_model

class PromotionsConfig(OscarConfig):
    label = 'promotions'
    name = 'Iuno.shop.promotions'
    verbose_name = _('Promotions')

    def ready(self):
        from Iuno.shop.promotions.views import HomeView, RecordClickView
        self.home_view = HomeView
        self.record_click_view = RecordClickView

    def get_urls(self):
        KeywordPromotion = get_model('promotions', 'KeywordPromotion')
        PagePromotion = get_model('promotions', 'PagePromotion')
        urls = [
            url(r'page-redirect/(?P<page_promotion_id>\d+)/$',
                self.record_click_view.as_view(model=PagePromotion),
                name='page-click'),
            url(r'keyword-redirect/(?P<keyword_promotion_id>\d+)/$',
                self.record_click_view.as_view(model=KeywordPromotion),
                name='keyword-click'),
            url(r'^$', self.home_view.as_view(), name='promotions-home'),
        ]
        return self.post_process_urls(urls)

