#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 9999 2017-05-29 10:48:02Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-29 18:48:02 +0800 (週一, 29 五月 2017) $
# $Revision: 9999 $

from django.db import models
from django.utils import timezone

class AdminPlaceholder(models.Model):
    name = models.CharField(max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=100, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True,
    )
    text = models.TextField()
    useGlobalAdminPlaceholder = models.BooleanField(default=False)
        
    def __unicode__(self):
        return u"AdminPlaceholder: %d" % (self.id,)
        
        
class BlockDisplayControl(models.Model):
    name = models.CharField(max_length=20, editable=False, null=True)
    fromUrl = models.CharField(max_length=100, editable=False, null=True)
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True
    )
    display = models.BooleanField(default=True)
    useGlobalBlockDisplayControl = models.BooleanField(default=False)
        
    def __unicode__(self):
        return u"BlockDisplayControl: %d" % (self.id,)
