#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Backends.py 12891 2021-05-06 07:13:31Z Lavender $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-05-06 15:13:31 +0800 (週四, 06 五月 2021) $
# $Revision: 12891 $

import os
import sys
import requests

from passlib.apache import HtpasswdFile

from django.conf import settings
from django.contrib.auth.backends import ModelBackend
from django.contrib.auth.models import User

DEFAULT_TRAC_AUTH_URL = 'https://code.nuwainfo.com/aec359bc3cfadb7504f26461a4c06625'
DEFAULT_TRAC_AUTH_USERNAME = 'Deploy'
DEFAULT_TRAC_AUTH_PASSWORD = 'ei0W1aUeP1pcRvJoV4X8ZC2xm'

def check(username, password, tracAuthURL=DEFAULT_TRAC_AUTH_URL, 
          tracUsername=DEFAULT_TRAC_AUTH_USERNAME, tracPassword=DEFAULT_TRAC_AUTH_PASSWORD):
    r = requests.get(tracAuthURL, auth=(tracUsername, tracPassword))
    content = r.text.strip()
    ht = HtpasswdFile.from_string(content)
    
    if ht.check_password(username, password):
        return True

    return False
    
class TracBackend(ModelBackend):

    def authenticate(self, request, username=None, password=None):
        valid = check(username, password)
        if valid:
            try:
                user = User.objects.get(username=username)
            except User.DoesNotExist:
                # Create a new user. There's no need to set a password
                user = User(username=username)
                user.is_staff = getattr(settings, "SET_TRAC_LOGIN_AS_STAFF", False)
                user.is_superuser = getattr(settings, "SET_TRAC_LOGIN_AS_SUPERUSER", False)
                user.save()
            return user
        return None